package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaObjectDeserializer implements ObjectDeserializer {
   public static final JavaObjectDeserializer instance = new JavaObjectDeserializer();

   public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
      if (type instanceof GenericArrayType) {
         Type componentType = ((GenericArrayType)type).getGenericComponentType();
         if (componentType instanceof TypeVariable) {
            TypeVariable<?> componentVar = (TypeVariable<?>)componentType;
            componentType = componentVar.getBounds()[0];
         }

         List<Object> list = new ArrayList<Object>();
         parser.parseArray(componentType, (Collection<Object>)list);
         Class<?> componentClass = TypeUtils.getRawClass(componentType);
         Object[] array = (Object[]) Array.newInstance(componentClass, list.size());
         list.toArray(array);
         return (T)array;
      } else {
         return (T)(type instanceof Class && type != Object.class && type != Serializable.class && type != Cloneable.class && type != Closeable.class && type != Comparable.class ? parser.parseObject(type) : parser.parse(fieldName));
      }
   }

   public int getFastMatchToken() {
      return 12;
   }
}
