package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapDeserializer extends ContextObjectDeserializer implements ObjectDeserializer {
   public static MapDeserializer instance = new MapDeserializer();

   public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, String format, int features) {
      if (type == JSONObject.class && parser.getFieldTypeResolver() == null) {
         return (T)parser.parseObject();
      } else {
         JSONLexer lexer = parser.lexer;
         if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
         } else {
            boolean unmodifiableMap = type instanceof Class && "java.util.Collections$UnmodifiableMap".equals(((Class)type).getName());
            Map<Object, Object> map = (lexer.getFeatures() & Feature.OrderedField.mask) != 0 ? this.createMap(type, lexer.getFeatures()) : this.createMap(type);
            ParseContext context = parser.getContext();

            Object var11;
            try {
               parser.setContext(context, map, fieldName);
               T t = (T)this.deserialze(parser, type, fieldName, map, features);
               if (unmodifiableMap) {
                  t = (T)Collections.unmodifiableMap((Map)t);
               }

               var11 = t;
            } finally {
               parser.setContext(context);
            }

            return (T)var11;
         }
      }
   }

   protected Object deserialze(DefaultJSONParser parser, Type type, Object fieldName, Map map) {
      return this.deserialze(parser, type, fieldName, (Map)map, 0);
   }

   protected Object deserialze(DefaultJSONParser parser, Type type, Object fieldName, Map map, int features) {
      if (type instanceof ParameterizedType) {
         ParameterizedType parameterizedType = (ParameterizedType)type;
         Type keyType = parameterizedType.getActualTypeArguments()[0];
         Type valueType = null;
         Object var9;
         if (map.getClass().getName().equals("org.springframework.util.LinkedMultiValueMap")) {
            var9 = List.class;
         } else {
            var9 = parameterizedType.getActualTypeArguments()[1];
         }

         return String.class == keyType ? parseMap(parser, map, (Type)var9, fieldName, features) : parseMap(parser, map, keyType, (Type)var9, fieldName);
      } else {
         return parser.parseObject(map, fieldName);
      }
   }

   public static Map parseMap(DefaultJSONParser parser, Map<String, Object> map, Type valueType, Object fieldName) {
      return parseMap(parser, map, valueType, fieldName, 0);
   }

   public static Map parseMap(DefaultJSONParser parser, Map<String, Object> map, Type valueType, Object fieldName, int features) {
      JSONLexer lexer = parser.lexer;
      int token = lexer.token();
      if (token != 12) {
         if (token == 4) {
            String stringVal = lexer.stringVal();
            if (stringVal.length() == 0 || stringVal.equals("null")) {
               return null;
            }
         }

         String msg = "syntax error, expect {, actual " + lexer.tokenName();
         if (fieldName instanceof String) {
            msg = msg + ", fieldName ";
            msg = msg + fieldName;
         }

         msg = msg + ", ";
         msg = msg + lexer.info();
         if (token != 4) {
            JSONArray array = new JSONArray();
            parser.parseArray(array, (Object)fieldName);
            if (array.size() == 1) {
               Object first = array.get(0);
               if (first instanceof JSONObject) {
                  return (JSONObject)first;
               }
            }
         }

         throw new JSONException(msg);
      } else {
         ParseContext context = parser.getContext();

         try {
            int i = 0;

            while(true) {
               lexer.skipWhitespace();
               char ch = lexer.getCurrent();
               if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                  while(ch == ',') {
                     lexer.next();
                     lexer.skipWhitespace();
                     ch = lexer.getCurrent();
                  }
               }

               String key;
               if (ch == '"') {
                  key = lexer.scanSymbol(parser.getSymbolTable(), '"');
                  lexer.skipWhitespace();
                  ch = lexer.getCurrent();
                  if (ch != ':') {
                     throw new JSONException("expect ':' at " + lexer.pos());
                  }
               } else {
                  if (ch == '}') {
                     lexer.next();
                     lexer.resetStringPosition();
                     lexer.nextToken(16);
                     Map var33 = map;
                     return var33;
                  }

                  if (ch == '\'') {
                     if (!lexer.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("syntax error");
                     }

                     key = lexer.scanSymbol(parser.getSymbolTable(), '\'');
                     lexer.skipWhitespace();
                     ch = lexer.getCurrent();
                     if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos());
                     }
                  } else {
                     if (!lexer.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                        throw new JSONException("syntax error");
                     }

                     key = lexer.scanSymbolUnQuoted(parser.getSymbolTable());
                     lexer.skipWhitespace();
                     ch = lexer.getCurrent();
                     if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                     }
                  }
               }

               lexer.next();
               lexer.skipWhitespace();
               ch = lexer.getCurrent();
               lexer.resetStringPosition();
               if (key == JSON.DEFAULT_TYPE_KEY && !lexer.isEnabled(Feature.DisableSpecialKeyDetect) && !Feature.isEnabled(features, Feature.DisableSpecialKeyDetect)) {
                  String typeName = lexer.scanSymbol(parser.getSymbolTable(), '"');
                  ParserConfig config = parser.getConfig();
                  Class<?> clazz;
                  if (typeName.equals("java.util.HashMap")) {
                     clazz = HashMap.class;
                  } else if (typeName.equals("java.util.LinkedHashMap")) {
                     clazz = LinkedHashMap.class;
                  } else if (config.isSafeMode()) {
                     clazz = HashMap.class;
                  } else {
                     try {
                        clazz = config.checkAutoType(typeName, (Class)null, lexer.getFeatures());
                     } catch (JSONException var19) {
                        clazz = HashMap.class;
                     }
                  }

                  if (!Map.class.isAssignableFrom(clazz)) {
                     ObjectDeserializer deserializer = config.getDeserializer((Type)clazz);
                     lexer.nextToken(16);
                     parser.setResolveStatus(2);
                     if (context != null && !(fieldName instanceof Integer)) {
                        parser.popContext();
                     }

                     Map var15 = (Map)deserializer.deserialze(parser, clazz, fieldName);
                     return var15;
                  }

                  lexer.nextToken(16);
                  if (lexer.token() == 13) {
                     lexer.nextToken(16);
                     Map ex = map;
                     return ex;
                  }
               } else {
                  lexer.nextToken();
                  if (i != 0) {
                     parser.setContext(context);
                  }

                  Object value;
                  if (lexer.token() == 8) {
                     value = null;
                     lexer.nextToken();
                  } else {
                     value = parser.parseObject((Type)valueType, key);
                  }

                  map.put(key, value);
                  parser.checkMapResolve(map, key);
                  parser.setContext(context, value, key);
                  parser.setContext(context);
                  int tok = lexer.token();
                  if (tok == 20 || tok == 15) {
                     Map clazz = map;
                     return clazz;
                  }

                  if (tok == 13) {
                     lexer.nextToken();
                     Map clazz = map;
                     return clazz;
                  }
               }

               ++i;
            }
         } finally {
            parser.setContext(context);
         }
      }
   }

   public static Object parseMap(DefaultJSONParser parser, Map<Object, Object> map, Type keyType, Type valueType, Object fieldName) {
      JSONLexer lexer = parser.lexer;
      if (lexer.token() != 12 && lexer.token() != 16) {
         throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
      } else {
         ObjectDeserializer keyDeserializer = parser.getConfig().getDeserializer(keyType);
         ObjectDeserializer valueDeserializer = parser.getConfig().getDeserializer(valueType);
         lexer.nextToken(keyDeserializer.getFastMatchToken());
         ParseContext context = parser.getContext();

         try {
            while(lexer.token() != 13) {
               if (lexer.token() == 4 && lexer.isRef() && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                  Object object = null;
                  lexer.nextTokenWithColon(4);
                  if (lexer.token() != 4) {
                     throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                  }

                  String ref = lexer.stringVal();
                  if ("..".equals(ref)) {
                     ParseContext parentContext = context.parent;
                     object = parentContext.object;
                  } else if (!"$".equals(ref)) {
                     parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, ref));
                     parser.setResolveStatus(1);
                  } else {
                     ParseContext rootContext;
                     for(rootContext = context; rootContext.parent != null; rootContext = rootContext.parent) {
                     }

                     object = rootContext.object;
                  }

                  lexer.nextToken(13);
                  if (lexer.token() != 13) {
                     throw new JSONException("illegal ref");
                  }

                  lexer.nextToken(16);
                  Object var19 = object;
                  return var19;
               }

               if (map.size() == 0 && lexer.token() == 4 && JSON.DEFAULT_TYPE_KEY.equals(lexer.stringVal()) && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                  lexer.nextTokenWithColon(4);
                  lexer.nextToken(16);
                  if (lexer.token() == 13) {
                     lexer.nextToken();
                     Map var15 = map;
                     return var15;
                  }

                  lexer.nextToken(keyDeserializer.getFastMatchToken());
               }

               Object key;
               if (lexer.token() == 4 && keyDeserializer instanceof JavaBeanDeserializer) {
                  String keyStrValue = lexer.stringVal();
                  lexer.nextToken();
                  DefaultJSONParser keyParser = new DefaultJSONParser(keyStrValue, parser.getConfig(), parser.getLexer().getFeatures());
                  keyParser.setDateFormat(parser.getDateFomartPattern());
                  key = keyDeserializer.deserialze(keyParser, keyType, null);
               } else {
                  key = keyDeserializer.deserialze(parser, keyType, null);
               }

               if (lexer.token() != 17) {
                  throw new JSONException("syntax error, expect :, actual " + lexer.token());
               }

               lexer.nextToken(valueDeserializer.getFastMatchToken());
               Object value = valueDeserializer.deserialze(parser, valueType, key);
               parser.checkMapResolve(map, key);
               map.put(key, value);
               if (lexer.token() == 16) {
                  lexer.nextToken(keyDeserializer.getFastMatchToken());
               }
            }

            lexer.nextToken(16);
            return map;
         } finally {
            parser.setContext(context);
         }
      }
   }

   public Map<Object, Object> createMap(Type type) {
      return this.createMap(type, JSON.DEFAULT_GENERATE_FEATURE);
   }

   public Map<Object, Object> createMap(Type type, int featrues) {
      if (type == Properties.class) {
         return new Properties();
      } else if (type == Hashtable.class) {
         return new Hashtable();
      } else if (type == IdentityHashMap.class) {
         return new IdentityHashMap();
      } else if (type != SortedMap.class && type != TreeMap.class) {
         if (type != ConcurrentMap.class && type != ConcurrentHashMap.class) {
            if (type == Map.class) {
               return (Map<Object, Object>)((featrues & Feature.OrderedField.mask) != 0 ? new LinkedHashMap() : new HashMap());
            } else if (type == HashMap.class) {
               return new HashMap();
            } else if (type == LinkedHashMap.class) {
               return new LinkedHashMap();
            } else if (type instanceof ParameterizedType) {
               ParameterizedType parameterizedType = (ParameterizedType)type;
               Type rawType = parameterizedType.getRawType();
               if (EnumMap.class.equals(rawType)) {
                  Type[] actualArgs = parameterizedType.getActualTypeArguments();
                  return new EnumMap((Class)actualArgs[0]);
               } else {
                  return this.createMap(rawType, featrues);
               }
            } else {
               Class<?> clazz = (Class)type;
               if (clazz.isInterface()) {
                  throw new JSONException("unsupport type " + type);
               } else if ("java.util.Collections$UnmodifiableMap".equals(clazz.getName())) {
                  return new HashMap();
               } else {
                  try {
                     return (Map)clazz.newInstance();
                  } catch (Exception e) {
                     throw new JSONException("unsupport type " + type, e);
                  }
               }
            }
         } else {
            return new ConcurrentHashMap();
         }
      } else {
         return new TreeMap();
      }
   }

   public int getFastMatchToken() {
      return 12;
   }
}
