package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class NumberDeserializer implements ObjectDeserializer {
   public static final NumberDeserializer instance = new NumberDeserializer();

   @SuppressWarnings("unchecked")
   public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
      JSONLexer lexer = parser.lexer;
      if (lexer.token() == 2) {
         if (clazz != Double.TYPE && clazz != Double.class) {
            long val = lexer.longValue();
            lexer.nextToken(16);
            if (clazz != Short.TYPE && clazz != Short.class) {
               if (clazz != Byte.TYPE && clazz != Byte.class) {
                  return (T)(Object)(val >= -2147483648L && val <= 2147483647L ? (int)val : val);
               } else if (val <= 127L && val >= -128L) {
                  return (T)(Object)(byte)((int)val);
               } else {
                  throw new JSONException("short overflow : " + val);
               }
            } else if (val <= 32767L && val >= -32768L) {
               return (T)(Object)(short)((int)val);
            } else {
               throw new JSONException("short overflow : " + val);
            }
         } else {
            String val = lexer.numberString();
            lexer.nextToken(16);
            return (T)(Object)Double.parseDouble(val);
         }
      } else if (lexer.token() == 3) {
         if (clazz != Double.TYPE && clazz != Double.class) {
            if (clazz != Short.TYPE && clazz != Short.class) {
               if (clazz != Byte.TYPE && clazz != Byte.class) {
                  BigDecimal val = lexer.decimalValue();
                  lexer.nextToken(16);
                  return (T)(Object)(lexer.isEnabled(Feature.UseBigDecimal) ? val : val.doubleValue());
               } else {
                  BigDecimal val = lexer.decimalValue();
                  lexer.nextToken(16);
                  byte byteValue = TypeUtils.byteValue(val);
                  return (T)(Object)byteValue;
               }
            } else {
               BigDecimal val = lexer.decimalValue();
               lexer.nextToken(16);
               short shortValue = TypeUtils.shortValue(val);
               return (T)(Object)shortValue;
            }
         } else {
            String val = lexer.numberString();
            lexer.nextToken(16);
            return (T)(Object)Double.parseDouble(val);
         }
      } else if (lexer.token() == 18 && "NaN".equals(lexer.stringVal())) {
         lexer.nextToken();
         Object nan = null;
         if (clazz == Double.class) {
            nan = Double.NaN;
         } else if (clazz == Float.class) {
            nan = Float.NaN;
         }

         return (T)nan;
      } else {
         Object value = parser.parse();
         if (value == null) {
            return null;
         } else if (clazz != Double.TYPE && clazz != Double.class) {
            if (clazz != Short.TYPE && clazz != Short.class) {
               if (clazz != Byte.TYPE && clazz != Byte.class) {
                  return (T)(Object)TypeUtils.castToBigDecimal(value);
               } else {
                  try {
                     return (T)(Object)TypeUtils.castToByte(value);
                  } catch (Exception ex) {
                     throw new JSONException("parseByte error, field : " + fieldName, ex);
                  }
               }
            } else {
               try {
                  return (T)(Object)TypeUtils.castToShort(value);
               } catch (Exception ex) {
                  throw new JSONException("parseShort error, field : " + fieldName, ex);
               }
            }
         } else {
            try {
               return (T)(Object)TypeUtils.castToDouble(value);
            } catch (Exception ex) {
               throw new JSONException("parseDouble error, field : " + fieldName, ex);
            }
         }
      }
   }

   public int getFastMatchToken() {
      return 2;
   }
}
