package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class OptionalCodec implements ObjectSerializer, ObjectDeserializer {
   public static OptionalCodec instance = new OptionalCodec();

   public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
      if (type == OptionalInt.class) {
         Object obj = parser.parseObject(Integer.class);
         Integer value = TypeUtils.castToInt(obj);
         return (T)(value == null ? OptionalInt.empty() : OptionalInt.of(value));
      } else if (type == OptionalLong.class) {
         Object obj = parser.parseObject(Long.class);
         Long value = TypeUtils.castToLong(obj);
         return (T)(value == null ? OptionalLong.empty() : OptionalLong.of(value));
      } else if (type == OptionalDouble.class) {
         Object obj = parser.parseObject(Double.class);
         Double value = TypeUtils.castToDouble(obj);
         return (T)(value == null ? OptionalDouble.empty() : OptionalDouble.of(value));
      } else {
         type = TypeUtils.unwrapOptional(type);
         Object value = parser.parseObject(type);
         return (T)(value == null ? Optional.empty() : Optional.of(value));
      }
   }

   public int getFastMatchToken() {
      return 12;
   }

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      if (object == null) {
         serializer.writeNull();
      } else if (object instanceof Optional) {
         Optional<?> optional = (Optional)object;
         Object value = optional.isPresent() ? optional.get() : null;
         serializer.write(value);
      } else if (object instanceof OptionalDouble) {
         OptionalDouble optional = (OptionalDouble)object;
         if (optional.isPresent()) {
            double value = optional.getAsDouble();
            serializer.write((Object)value);
         } else {
            serializer.writeNull();
         }

      } else if (object instanceof OptionalInt) {
         OptionalInt optional = (OptionalInt)object;
         if (optional.isPresent()) {
            int value = optional.getAsInt();
            serializer.out.writeInt(value);
         } else {
            serializer.writeNull();
         }

      } else if (object instanceof OptionalLong) {
         OptionalLong optional = (OptionalLong)object;
         if (optional.isPresent()) {
            long value = optional.getAsLong();
            serializer.out.writeLong(value);
         } else {
            serializer.writeNull();
         }

      } else {
         throw new JSONException("not support optional : " + object.getClass());
      }
   }
}
