package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import java.lang.reflect.Type;

public class PropertyProcessableDeserializer implements ObjectDeserializer {
   public final Class<PropertyProcessable> type;

   public PropertyProcessableDeserializer(Class<PropertyProcessable> type) {
      this.type = type;
   }

   public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
      PropertyProcessable processable;
      try {
         processable = (PropertyProcessable)this.type.newInstance();
      } catch (Exception var6) {
         throw new JSONException("craete instance error");
      }

      Object object = parser.parse(processable, fieldName);
      return (T)object;
   }

   public int getFastMatchToken() {
      return 12;
   }
}
