package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;

public class SqlDateDeserializer extends AbstractDateDeserializer implements ObjectDeserializer {
   public static final SqlDateDeserializer instance = new SqlDateDeserializer();
   public static final SqlDateDeserializer instance_timestamp = new SqlDateDeserializer(true);
   private boolean timestamp = false;

   public SqlDateDeserializer() {
   }

   public SqlDateDeserializer(boolean timestmap) {
      this.timestamp = true;
   }

   protected <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
      if (this.timestamp) {
         return (T)this.castTimestamp(parser, clazz, fieldName, val);
      } else if (val == null) {
         return null;
      } else {
         Date var18;
         if (val instanceof java.util.Date) {
            var18 = new Date(((java.util.Date)val).getTime());
         } else if (val instanceof BigDecimal) {
            var18 = new Date(TypeUtils.longValue((BigDecimal)val));
         } else {
            if (!(val instanceof Number)) {
               if (!(val instanceof String)) {
                  throw new JSONException("parse error : " + val);
               }

               String strVal = (String)val;
               if (strVal.length() == 0) {
                  return null;
               }

               JSONScanner dateLexer = new JSONScanner(strVal);

               Date var12;
               try {
                  long longVal;
                  if (dateLexer.scanISO8601DateIfMatch()) {
                     longVal = dateLexer.getCalendar().getTimeInMillis();
                     return (T)(new Date(longVal));
                  }

                  DateFormat dateFormat = parser.getDateFormat();

                  try {
                     java.util.Date date = dateFormat.parse(strVal);
                     Date sqlDate = new Date(date.getTime());
                     var12 = sqlDate;
                  } catch (ParseException var16) {
                     longVal = Long.parseLong(strVal);
                     return (T)(new Date(longVal));
                  }
               } finally {
                  dateLexer.close();
               }

               return (T)var12;
            }

            var18 = new Date(((Number)val).longValue());
         }

         return (T)var18;
      }
   }

   protected <T> T castTimestamp(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
      if (val == null) {
         return null;
      } else if (val instanceof java.util.Date) {
         return (T)(new Timestamp(((java.util.Date)val).getTime()));
      } else if (val instanceof BigDecimal) {
         return (T)(new Timestamp(TypeUtils.longValue((BigDecimal)val)));
      } else if (val instanceof Number) {
         return (T)(new Timestamp(((Number)val).longValue()));
      } else if (!(val instanceof String)) {
         throw new JSONException("parse error");
      } else {
         String strVal = (String)val;
         if (strVal.length() == 0) {
            return null;
         } else {
            JSONScanner dateLexer = new JSONScanner(strVal);

            try {
               if (strVal.length() > 19 && strVal.charAt(4) == '-' && strVal.charAt(7) == '-' && strVal.charAt(10) == ' ' && strVal.charAt(13) == ':' && strVal.charAt(16) == ':' && strVal.charAt(19) == '.') {
                  String dateFomartPattern = parser.getDateFomartPattern();
                  if (dateFomartPattern.length() != strVal.length() && dateFomartPattern == JSON.DEFFAULT_DATE_FORMAT) {
                     Timestamp var19 = Timestamp.valueOf(strVal);
                     return (T)var19;
                  }
               }

               long longVal;
               if (dateLexer.scanISO8601DateIfMatch(false)) {
                  longVal = dateLexer.getCalendar().getTimeInMillis();
                  return (T)(new Timestamp(longVal));
               } else {
                  DateFormat dateFormat = parser.getDateFormat();

                  try {
                     java.util.Date date = dateFormat.parse(strVal);
                     Timestamp sqlDate = new Timestamp(date.getTime());
                     Timestamp var12 = sqlDate;
                     return (T)var12;
                  } catch (ParseException var16) {
                     longVal = Long.parseLong(strVal);
                     return (T)(new Timestamp(longVal));
                  }
               }
            } finally {
               dateLexer.close();
            }
         }
      }
   }

   public int getFastMatchToken() {
      return 2;
   }
}
