package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Time;

public class TimeDeserializer implements ObjectDeserializer {
   public static final TimeDeserializer instance = new TimeDeserializer();

   public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
      JSONLexer lexer = parser.lexer;
      if (lexer.token() == 16) {
         lexer.nextToken(4);
         if (lexer.token() != 4) {
            throw new JSONException("syntax error");
         } else {
            lexer.nextTokenWithColon(2);
            if (lexer.token() != 2) {
               throw new JSONException("syntax error");
            } else {
               long time = lexer.longValue();
               lexer.nextToken(13);
               if (lexer.token() != 13) {
                  throw new JSONException("syntax error");
               } else {
                  lexer.nextToken(16);
                  return (T)(new Time(time));
               }
            }
         }
      } else {
         Object val = parser.parse();
         if (val == null) {
            return null;
         } else if (val instanceof Time) {
            return (T)val;
         } else if (val instanceof BigDecimal) {
            return (T)(new Time(TypeUtils.longValue((BigDecimal)val)));
         } else if (val instanceof Number) {
            return (T)(new Time(((Number)val).longValue()));
         } else if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 0) {
               return null;
            } else {
               JSONScanner dateLexer = new JSONScanner(strVal);
               long longVal;
               if (dateLexer.scanISO8601DateIfMatch()) {
                  longVal = dateLexer.getCalendar().getTimeInMillis();
               } else {
                  boolean isDigit = true;

                  for(int i = 0; i < strVal.length(); ++i) {
                     char ch = strVal.charAt(i);
                     if (ch < '0' || ch > '9') {
                        isDigit = false;
                        break;
                     }
                  }

                  if (!isDigit) {
                     dateLexer.close();
                     return (T)Time.valueOf(strVal);
                  }

                  longVal = Long.parseLong(strVal);
               }

               dateLexer.close();
               return (T)(new Time(longVal));
            }
         } else {
            throw new JSONException("parse error");
         }
      }
   }

   public int getFastMatchToken() {
      return 2;
   }
}
