package com.alibaba.fastjson.serializer;

public abstract class BeforeFilter implements SerializeFilter {
   private static final ThreadLocal<JSONSerializer> serializerLocal = new ThreadLocal();
   private static final ThreadLocal<Character> seperatorLocal = new ThreadLocal();
   private static final Character COMMA = ',';

   final char writeBefore(JSONSerializer serializer, Object object, char seperator) {
      JSONSerializer last = (JSONSerializer)serializerLocal.get();
      serializerLocal.set(serializer);
      seperatorLocal.set(seperator);
      this.writeBefore(object);
      serializerLocal.set(last);
      return (Character)seperatorLocal.get();
   }

   protected final void writeKeyValue(String key, Object value) {
      JSONSerializer serializer = (JSONSerializer)serializerLocal.get();
      char seperator = (Character)seperatorLocal.get();
      boolean ref = serializer.references.containsKey(value);
      serializer.writeKeyValue(seperator, key, value);
      if (!ref) {
         serializer.references.remove(value);
      }

      if (seperator != ',') {
         seperatorLocal.set(COMMA);
      }

   }

   public abstract void writeBefore(Object var1);
}
