package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.util.Collection;

public class CharArrayCodec implements ObjectDeserializer {
   public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
      return (T)deserialze(parser);
   }

   public static <T> T deserialze(DefaultJSONParser parser) {
      JSONLexer lexer = parser.lexer;
      if (lexer.token() == 4) {
         String val = lexer.stringVal();
         lexer.nextToken(16);
         return (T)val.toCharArray();
      } else if (lexer.token() == 2) {
         Number val = lexer.integerValue();
         lexer.nextToken(16);
         return (T)val.toString().toCharArray();
      } else {
         Object value = parser.parse();
         if (value instanceof String) {
            return (T)((String)value).toCharArray();
         } else if (!(value instanceof Collection)) {
            return (T)(value == null ? null : JSON.toJSONString(value).toCharArray());
         } else {
            Collection<?> collection = (Collection)value;
            boolean accept = true;

            for(Object item : collection) {
               if (item instanceof String) {
                  int itemLength = ((String)item).length();
                  if (itemLength != 1) {
                     accept = false;
                     break;
                  }
               }
            }

            if (!accept) {
               throw new JSONException("can not cast to char[]");
            } else {
               char[] chars = new char[collection.size()];
               int pos = 0;

               for(Object item : collection) {
                  chars[pos++] = ((String)item).charAt(0);
               }

               return (T)chars;
            }
         }
      }
   }

   public int getFastMatchToken() {
      return 4;
   }
}
