package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.AbstractDateDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateCodec extends AbstractDateDeserializer implements ObjectSerializer, ObjectDeserializer {
   public static final DateCodec instance = new DateCodec();

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      SerializeWriter out = serializer.out;
      if (object == null) {
         out.writeNull();
      } else {
         Class<?> clazz = object.getClass();
         if (clazz == Date.class && !out.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            long millis = ((Date)object).getTime();
            TimeZone timeZone = serializer.timeZone;
            int offset = timeZone.getOffset(millis);
            if ((millis + (long)offset) % 86400000L == 0L && !SerializerFeature.isEnabled(out.features, features, SerializerFeature.WriteClassName)) {
               out.writeString(object.toString());
               return;
            }
         }

         if (clazz == Time.class) {
            long millis = ((Time)object).getTime();
            if ("unixtime".equals(serializer.getDateFormatPattern())) {
               long seconds = millis / 1000L;
               out.writeLong(seconds);
               return;
            }

            if ("millis".equals(serializer.getDateFormatPattern())) {
               out.writeLong(millis);
               return;
            }

            if (millis < 86400000L) {
               out.writeString(object.toString());
               return;
            }
         }

         int nanos = 0;
         if (clazz == Timestamp.class) {
            Timestamp ts = (Timestamp)object;
            nanos = ts.getNanos();
         }

         java.util.Date date;
         if (object instanceof java.util.Date) {
            date = (java.util.Date)object;
         } else {
            date = TypeUtils.castToDate(object);
         }

         if ("unixtime".equals(serializer.getDateFormatPattern())) {
            long seconds = date.getTime() / 1000L;
            out.writeLong(seconds);
         } else if ("millis".equals(serializer.getDateFormatPattern())) {
            long millis = date.getTime();
            out.writeLong(millis);
         } else if (out.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            DateFormat format = serializer.getDateFormat();
            if (format == null) {
               String dateFormatPattern = serializer.getFastJsonConfigDateFormatPattern();
               if (dateFormatPattern == null) {
                  dateFormatPattern = JSON.DEFFAULT_DATE_FORMAT;
               }

               format = new SimpleDateFormat(dateFormatPattern, serializer.locale);
               format.setTimeZone(serializer.timeZone);
            }

            String text = format.format(date);
            out.writeString(text);
         } else if (out.isEnabled(SerializerFeature.WriteClassName) && clazz != fieldType) {
            if (clazz == java.util.Date.class) {
               out.write("new Date(");
               out.writeLong(((java.util.Date)object).getTime());
               out.write(41);
            } else {
               out.write(123);
               out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
               serializer.write(clazz.getName());
               out.writeFieldValue(',', "val", ((java.util.Date)object).getTime());
               out.write(125);
            }

         } else {
            long time = date.getTime();
            if (out.isEnabled(SerializerFeature.UseISO8601DateFormat)) {
               char quote = (char)(out.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34);
               out.write(quote);
               Calendar calendar = Calendar.getInstance(serializer.timeZone, serializer.locale);
               calendar.setTimeInMillis(time);
               int year = calendar.get(1);
               int month = calendar.get(2) + 1;
               int day = calendar.get(5);
               int hour = calendar.get(11);
               int minute = calendar.get(12);
               int second = calendar.get(13);
               int millis = calendar.get(14);
               char[] buf;
               if (nanos > 0) {
                  buf = "0000-00-00 00:00:00.000000000".toCharArray();
                  IOUtils.getChars((int)nanos, 29, buf);
                  IOUtils.getChars((int)second, 19, buf);
                  IOUtils.getChars((int)minute, 16, buf);
                  IOUtils.getChars((int)hour, 13, buf);
                  IOUtils.getChars((int)day, 10, buf);
                  IOUtils.getChars((int)month, 7, buf);
                  IOUtils.getChars((int)year, 4, buf);
               } else if (millis != 0) {
                  buf = "0000-00-00T00:00:00.000".toCharArray();
                  IOUtils.getChars((int)millis, 23, buf);
                  IOUtils.getChars((int)second, 19, buf);
                  IOUtils.getChars((int)minute, 16, buf);
                  IOUtils.getChars((int)hour, 13, buf);
                  IOUtils.getChars((int)day, 10, buf);
                  IOUtils.getChars((int)month, 7, buf);
                  IOUtils.getChars((int)year, 4, buf);
               } else if (second == 0 && minute == 0 && hour == 0) {
                  buf = "0000-00-00".toCharArray();
                  IOUtils.getChars((int)day, 10, buf);
                  IOUtils.getChars((int)month, 7, buf);
                  IOUtils.getChars((int)year, 4, buf);
               } else {
                  buf = "0000-00-00T00:00:00".toCharArray();
                  IOUtils.getChars((int)second, 19, buf);
                  IOUtils.getChars((int)minute, 16, buf);
                  IOUtils.getChars((int)hour, 13, buf);
                  IOUtils.getChars((int)day, 10, buf);
                  IOUtils.getChars((int)month, 7, buf);
                  IOUtils.getChars((int)year, 4, buf);
               }

               if (nanos > 0) {
                  int i;
                  for(i = 0; i < 9; ++i) {
                     int off = buf.length - i - 1;
                     if (buf[off] != '0') {
                        break;
                     }
                  }

                  out.write((char[])buf, 0, buf.length - i);
                  out.write(quote);
                  return;
               }

               out.write((char[])buf);
               float timeZoneF = (float)calendar.getTimeZone().getOffset(calendar.getTimeInMillis()) / 3600000.0F;
               int timeZone = (int)timeZoneF;
               if ((double)timeZone == (double)0.0F) {
                  out.write(90);
               } else {
                  if (timeZone > 9) {
                     out.write(43);
                     out.writeInt(timeZone);
                  } else if (timeZone > 0) {
                     out.write(43);
                     out.write(48);
                     out.writeInt(timeZone);
                  } else if (timeZone < -9) {
                     out.write(45);
                     out.writeInt(-timeZone);
                  } else if (timeZone < 0) {
                     out.write(45);
                     out.write(48);
                     out.writeInt(-timeZone);
                  }

                  out.write(58);
                  int offSet = (int)(Math.abs(timeZoneF - (float)timeZone) * 60.0F);
                  out.append(String.format("%02d", offSet));
               }

               out.write(quote);
            } else {
               out.writeLong(time);
            }

         }
      }
   }

   public <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
      if (val == null) {
         return null;
      } else if (val instanceof java.util.Date) {
         return (T)val;
      } else if (val instanceof BigDecimal) {
         return (T)(new java.util.Date(TypeUtils.longValue((BigDecimal)val)));
      } else if (val instanceof Number) {
         return (T)(new java.util.Date(((Number)val).longValue()));
      } else if (val instanceof String) {
         String strVal = (String)val;
         if (strVal.length() == 0) {
            return null;
         } else {
            if (strVal.length() == 23 && strVal.endsWith(" 000")) {
               strVal = strVal.substring(0, 19);
            }

            JSONScanner dateLexer = new JSONScanner(strVal);

            try {
               if (dateLexer.scanISO8601DateIfMatch(false)) {
                  Calendar calendar = dateLexer.getCalendar();
                  if (clazz == Calendar.class) {
                     Calendar var27 = calendar;
                     return (T)var27;
                  }

                  java.util.Date var8 = calendar.getTime();
                  return (T)var8;
               }
            } finally {
               dateLexer.close();
            }

            String dateFomartPattern = parser.getDateFomartPattern();
            boolean formatMatch = strVal.length() == dateFomartPattern.length() || strVal.length() == 22 && dateFomartPattern.equals("yyyyMMddHHmmssSSSZ") || strVal.indexOf(84) != -1 && dateFomartPattern.contains("'T'") && strVal.length() + 2 == dateFomartPattern.length();
            if (formatMatch) {
               DateFormat dateFormat = parser.getDateFormat();

               try {
                  return (T)dateFormat.parse(strVal);
               } catch (ParseException var23) {
               }
            }

            if (strVal.startsWith("/Date(") && strVal.endsWith(")/")) {
               String dotnetDateStr = strVal.substring(6, strVal.length() - 2);
               strVal = dotnetDateStr;
            }

            if (!"0000-00-00".equals(strVal) && !"0000-00-00T00:00:00".equalsIgnoreCase(strVal) && !"0001-01-01T00:00:00+08:00".equalsIgnoreCase(strVal)) {
               int index = strVal.lastIndexOf(124);
               if (index > 20) {
                  String tzStr = strVal.substring(index + 1);
                  TimeZone timeZone = TimeZone.getTimeZone(tzStr);
                  if (!"GMT".equals(timeZone.getID())) {
                     String subStr = strVal.substring(0, index);
                     JSONScanner dateLexer2 = new JSONScanner(subStr);

                     Calendar var14;
                     try {
                        if (!dateLexer2.scanISO8601DateIfMatch(false)) {
                           return null;
                        }

                        Calendar calendar = dateLexer2.getCalendar();
                        calendar.setTimeZone(timeZone);
                        if (clazz != Calendar.class) {
                           java.util.Date var32 = calendar.getTime();
                           return (T)var32;
                        }

                        var14 = calendar;
                     } finally {
                        dateLexer2.close();
                     }

                     return (T)var14;
                  }
               }

               long longVal = Long.parseLong(strVal);
               return (T)(new java.util.Date(longVal));
            } else {
               return null;
            }
         }
      } else {
         throw new JSONException("parse error");
      }
   }

   public int getFastMatchToken() {
      return 2;
   }
}
