package com.alibaba.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DecimalFormat;

public class DoubleSerializer implements ObjectSerializer {
   public static final DoubleSerializer instance = new DoubleSerializer();
   private DecimalFormat decimalFormat;

   public DoubleSerializer() {
      this.decimalFormat = null;
   }

   public DoubleSerializer(DecimalFormat decimalFormat) {
      this.decimalFormat = null;
      this.decimalFormat = decimalFormat;
   }

   public DoubleSerializer(String decimalFormat) {
      this(new DecimalFormat(decimalFormat));
   }

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      SerializeWriter out = serializer.out;
      if (object == null) {
         out.writeNull(SerializerFeature.WriteNullNumberAsZero);
      } else {
         double doubleValue = (Double)object;
         if (!Double.isNaN(doubleValue) && !Double.isInfinite(doubleValue)) {
            if (this.decimalFormat == null) {
               out.writeDouble(doubleValue, true);
            } else {
               String doubleText = this.decimalFormat.format(doubleValue);
               out.write(doubleText);
            }
         } else {
            out.writeNull();
         }

      }
   }
}
