package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class EnumSerializer implements ObjectSerializer {
   private final Member member;
   public static final EnumSerializer instance = new EnumSerializer();

   public EnumSerializer() {
      this.member = null;
   }

   public EnumSerializer(Member member) {
      this.member = member;
   }

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      if (this.member == null) {
         SerializeWriter out = serializer.out;
         out.writeEnum((Enum)object);
      } else {
         Object fieldValue = null;

         try {
            if (this.member instanceof Field) {
               fieldValue = ((Field)this.member).get(object);
            } else {
               fieldValue = ((Method)this.member).invoke(object);
            }
         } catch (Exception e) {
            throw new JSONException("getEnumValue error", e);
         }

         serializer.write(fieldValue);
      }
   }
}
