package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FloatCodec implements ObjectSerializer, ObjectDeserializer {
   private NumberFormat decimalFormat;
   public static FloatCodec instance = new FloatCodec();

   public FloatCodec() {
   }

   public FloatCodec(DecimalFormat decimalFormat) {
      this.decimalFormat = decimalFormat;
   }

   public FloatCodec(String decimalFormat) {
      this(new DecimalFormat(decimalFormat));
   }

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      SerializeWriter out = serializer.out;
      if (object == null) {
         out.writeNull(SerializerFeature.WriteNullNumberAsZero);
      } else {
         float floatValue = (Float)object;
         if (this.decimalFormat != null) {
            String floatText = this.decimalFormat.format((double)floatValue);
            out.write(floatText);
         } else {
            out.writeFloat(floatValue, true);
         }

      }
   }

   public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
      try {
         return (T)deserialze(parser);
      } catch (Exception ex) {
         throw new JSONException("parseLong error, field : " + fieldName, ex);
      }
   }

   public static <T> T deserialze(DefaultJSONParser parser) {
      JSONLexer lexer = parser.lexer;
      if (lexer.token() == 2) {
         String val = lexer.numberString();
         lexer.nextToken(16);
         return (T)Float.valueOf(Float.parseFloat(val));
      } else if (lexer.token() == 3) {
         float val = lexer.floatValue();
         lexer.nextToken(16);
         return (T)Float.valueOf(val);
      } else {
         Object value = parser.parse();
         return (T)(value == null ? null : TypeUtils.castToFloat(value));
      }
   }

   public int getFastMatchToken() {
      return 2;
   }
}
