package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;

public class JSONLibDataFormatSerializer implements ObjectSerializer {
   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      if (object == null) {
         serializer.out.writeNull();
      } else {
         Date date = (Date)object;
         JSONObject json = new JSONObject();
         json.put((String)"date", date.getDate());
         json.put((String)"day", date.getDay());
         json.put((String)"hours", date.getHours());
         json.put((String)"minutes", date.getMinutes());
         json.put((String)"month", date.getMonth());
         json.put((String)"seconds", date.getSeconds());
         json.put((String)"time", date.getTime());
         json.put((String)"timezoneOffset", date.getTimezoneOffset());
         json.put((String)"year", date.getYear());
         serializer.write((Object)json);
      }
   }
}
