package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MapSerializer extends SerializeFilterable implements ObjectSerializer {
   public static MapSerializer instance = new MapSerializer();
   private static final int NON_STRINGKEY_AS_STRING;

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      this.write(serializer, object, fieldName, fieldType, features, false);
   }

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features, boolean unwrapped) throws IOException {
      SerializeWriter out = serializer.out;
      if (object == null) {
         out.writeNull();
      } else {
         Map<?, ?> map = (Map)object;
         int mapSortFieldMask = SerializerFeature.MapSortField.mask;
         if ((out.features & mapSortFieldMask) != 0 || (features & mapSortFieldMask) != 0) {
            if (map instanceof JSONObject) {
               map = ((JSONObject) map).getInnerMap();
            }

            if (!(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
               try {
                  map = new TreeMap(map);
               } catch (Exception var25) {
               }
            }
         }

         if (serializer.containsReference(object)) {
            serializer.writeReference(object);
         } else {
            SerialContext parent = serializer.context;
            serializer.setContext(parent, object, fieldName, 0);

            try {
               if (!unwrapped) {
                  out.write(123);
               }

               serializer.incrementIndent();
               Class<?> preClazz = null;
               ObjectSerializer preWriter = null;
               boolean first = true;
               if (out.isEnabled(SerializerFeature.WriteClassName)) {
                  String typeKey = serializer.config.typeKey;
                  Class<?> mapClass = map.getClass();
                  boolean containsKey = (mapClass == JSONObject.class || mapClass == HashMap.class || mapClass == LinkedHashMap.class) && map.containsKey(typeKey);
                  if (!containsKey) {
                     out.writeFieldName(typeKey);
                     out.writeString(object.getClass().getName());
                     first = false;
                  }
               }

               for(Map.Entry entry : map.entrySet()) {
                  Object value = entry.getValue();
                  Object entryKey = entry.getKey();
                  List<PropertyPreFilter> preFilters = serializer.propertyPreFilters;
                  if (preFilters != null && preFilters.size() > 0) {
                     if (entryKey != null && !(entryKey instanceof String)) {
                        if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                           String strKey = JSON.toJSONString(entryKey);
                           if (!this.applyName(serializer, object, strKey)) {
                              continue;
                           }
                        }
                     } else if (!this.applyName(serializer, object, (String)entryKey)) {
                        continue;
                     }
                  }

                  preFilters = this.propertyPreFilters;
                  if (preFilters != null && preFilters.size() > 0) {
                     if (entryKey != null && !(entryKey instanceof String)) {
                        if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                           String strKey = JSON.toJSONString(entryKey);
                           if (!this.applyName(serializer, object, strKey)) {
                              continue;
                           }
                        }
                     } else if (!this.applyName(serializer, object, (String)entryKey)) {
                        continue;
                     }
                  }

                  List<PropertyFilter> propertyFilters = serializer.propertyFilters;
                  if (propertyFilters != null && propertyFilters.size() > 0) {
                     if (entryKey != null && !(entryKey instanceof String)) {
                        if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                           String strKey = JSON.toJSONString(entryKey);
                           if (!this.apply(serializer, object, strKey, value)) {
                              continue;
                           }
                        }
                     } else if (!this.apply(serializer, object, (String)entryKey, value)) {
                        continue;
                     }
                  }

                  propertyFilters = this.propertyFilters;
                  if (propertyFilters != null && propertyFilters.size() > 0) {
                     if (entryKey != null && !(entryKey instanceof String)) {
                        if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                           String strKey = JSON.toJSONString(entryKey);
                           if (!this.apply(serializer, object, strKey, value)) {
                              continue;
                           }
                        }
                     } else if (!this.apply(serializer, object, (String)entryKey, value)) {
                        continue;
                     }
                  }

                  List<NameFilter> nameFilters = serializer.nameFilters;
                  if (nameFilters != null && nameFilters.size() > 0) {
                     if (entryKey != null && !(entryKey instanceof String)) {
                        if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                           String strKey = JSON.toJSONString(entryKey);
                           entryKey = this.processKey(serializer, object, strKey, value);
                        }
                     } else {
                        entryKey = this.processKey(serializer, object, (String)entryKey, value);
                     }
                  }

                  nameFilters = this.nameFilters;
                  if (nameFilters != null && nameFilters.size() > 0) {
                     if (entryKey != null && !(entryKey instanceof String)) {
                        if (entryKey.getClass().isPrimitive() || entryKey instanceof Number) {
                           String strKey = JSON.toJSONString(entryKey);
                           entryKey = this.processKey(serializer, object, strKey, value);
                        }
                     } else {
                        entryKey = this.processKey(serializer, object, (String)entryKey, value);
                     }
                  }

                  if (entryKey != null && !(entryKey instanceof String)) {
                     boolean objectOrArray = entryKey instanceof Map || entryKey instanceof Collection;
                     if (!objectOrArray) {
                        String strKey = JSON.toJSONString(entryKey);
                        value = this.processValue(serializer, (BeanContext)null, object, strKey, value, features);
                     }
                  } else {
                     value = this.processValue(serializer, (BeanContext)null, object, (String)entryKey, value, features);
                  }

                  if (value != null || SerializerFeature.isEnabled(out.features, features, SerializerFeature.WriteMapNullValue)) {
                     if (entryKey instanceof String) {
                        String key = (String)entryKey;
                        if (!first) {
                           out.write(44);
                        }

                        if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                           serializer.println();
                        }

                        out.writeFieldName(key, true);
                     } else {
                        if (!first) {
                           out.write(44);
                        }

                        if ((out.isEnabled(NON_STRINGKEY_AS_STRING) || SerializerFeature.isEnabled(features, SerializerFeature.WriteNonStringKeyAsString)) && !(entryKey instanceof Enum)) {
                           String strEntryKey = JSON.toJSONString(entryKey);
                           serializer.write(strEntryKey);
                        } else {
                           serializer.write(entryKey);
                        }

                        out.write(58);
                     }

                     first = false;
                     if (value == null) {
                        out.writeNull();
                     } else {
                        Class<?> clazz = value.getClass();
                        if (clazz != preClazz) {
                           preClazz = clazz;
                           preWriter = serializer.getObjectWriter(clazz);
                        }

                        if (SerializerFeature.isEnabled(features, SerializerFeature.WriteClassName) && preWriter instanceof JavaBeanSerializer) {
                           Type valueType = null;
                           if (fieldType instanceof ParameterizedType) {
                              ParameterizedType parameterizedType = (ParameterizedType)fieldType;
                              Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                              if (actualTypeArguments.length == 2) {
                                 valueType = actualTypeArguments[1];
                              }
                           }

                           JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)preWriter;
                           javaBeanSerializer.writeNoneASM(serializer, value, entryKey, valueType, features);
                        } else {
                           preWriter.write(serializer, value, entryKey, (Type)null, features);
                        }
                     }
                  }
               }
            } finally {
               serializer.context = parent;
            }

            serializer.decrementIdent();
            if (out.isEnabled(SerializerFeature.PrettyFormat) && map.size() > 0) {
               serializer.println();
            }

            if (!unwrapped) {
               out.write(125);
            }

         }
      }
   }

   static {
      NON_STRINGKEY_AS_STRING = SerializerFeature.of(new SerializerFeature[]{SerializerFeature.BrowserCompatible, SerializerFeature.WriteNonStringKeyAsString, SerializerFeature.BrowserSecure});
   }
}
