package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONAware;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONStreamAware;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.deserializer.Jdk8DateCodec;
import com.alibaba.fastjson.parser.deserializer.OptionalCodec;
import com.alibaba.fastjson.spi.Module;
import com.alibaba.fastjson.util.ASMUtils;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.IdentityHashMap;
import com.alibaba.fastjson.util.ServiceLoader;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Node;

public class SerializeConfig {
   public static final SerializeConfig globalInstance = new SerializeConfig();
   private static boolean awtError = false;
   private static boolean jdk8Error = false;
   private static boolean oracleJdbcError = false;
   private static boolean springfoxError = false;
   private static boolean guavaError = false;
   private static boolean jodaError = false;
   private boolean asm;
   private ASMSerializerFactory asmFactory;
   protected String typeKey;
   public PropertyNamingStrategy propertyNamingStrategy;
   private final IdentityHashMap<Type, ObjectSerializer> serializers;
   private final IdentityHashMap<Type, IdentityHashMap<Type, ObjectSerializer>> mixInSerializers;
   private final boolean fieldBased;
   private long[] denyClasses;
   private List<Module> modules;

   public String getTypeKey() {
      return this.typeKey;
   }

   public void setTypeKey(String typeKey) {
      this.typeKey = typeKey;
   }

   private final JavaBeanSerializer createASMSerializer(SerializeBeanInfo beanInfo) throws Exception {
      JavaBeanSerializer serializer = this.asmFactory.createJavaBeanSerializer(beanInfo);

      for(int i = 0; i < serializer.sortedGetters.length; ++i) {
         FieldSerializer fieldDeser = serializer.sortedGetters[i];
         Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
         if (fieldClass.isEnum()) {
            ObjectSerializer fieldSer = this.getObjectWriter(fieldClass);
            if (!(fieldSer instanceof EnumSerializer)) {
               serializer.writeDirect = false;
            }
         }
      }

      return serializer;
   }

   public final ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
      String className = clazz.getName();
      long hashCode64 = TypeUtils.fnv1a_64(className);
      if (Arrays.binarySearch(this.denyClasses, hashCode64) >= 0) {
         throw new JSONException("not support class : " + className);
      } else {
         SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, (Map)null, this.propertyNamingStrategy, this.fieldBased);
         return (ObjectSerializer)(beanInfo.fields.length == 0 && Iterable.class.isAssignableFrom(clazz) ? MiscCodec.instance : this.createJavaBeanSerializer(beanInfo));
      }
   }

   public ObjectSerializer createJavaBeanSerializer(SerializeBeanInfo beanInfo) {
      JSONType jsonType = beanInfo.jsonType;
      boolean asm = this.asm && !this.fieldBased;
      if (jsonType != null) {
         Class<?> serializerClass = jsonType.serializer();
         if (serializerClass != Void.class) {
            try {
               Object seralizer = serializerClass.newInstance();
               if (seralizer instanceof ObjectSerializer) {
                  return (ObjectSerializer)seralizer;
               }
            } catch (Throwable var17) {
            }
         }

         if (!jsonType.asm()) {
            asm = false;
         }

         if (asm) {
            for(SerializerFeature feature : jsonType.serialzeFeatures()) {
               if (SerializerFeature.WriteNonStringValueAsString == feature || SerializerFeature.WriteEnumUsingToString == feature || SerializerFeature.NotWriteDefaultValue == feature || SerializerFeature.BrowserCompatible == feature) {
                  asm = false;
                  break;
               }
            }
         }

         if (asm) {
            Class<? extends SerializeFilter>[] filterClasses = jsonType.serialzeFilters();
            if (filterClasses.length != 0) {
               asm = false;
            }
         }
      }

      Class<?> clazz = beanInfo.beanType;
      if (!Modifier.isPublic(beanInfo.beanType.getModifiers())) {
         return new JavaBeanSerializer(beanInfo);
      } else {
         if (asm && this.asmFactory.classLoader.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            asm = false;
         }

         if (asm && !ASMUtils.checkName(clazz.getSimpleName())) {
            asm = false;
         }

         if (asm && beanInfo.beanType.isInterface()) {
            asm = false;
         }

         if (asm) {
            label172:
            for(FieldInfo fieldInfo : beanInfo.fields) {
               Field field = fieldInfo.field;
               if (field != null && !field.getType().equals(fieldInfo.fieldClass)) {
                  asm = false;
                  break;
               }

               Method method = fieldInfo.method;
               if (method != null && !method.getReturnType().equals(fieldInfo.fieldClass)) {
                  asm = false;
                  break;
               }

               if (fieldInfo.fieldClass.isEnum() && this.get(fieldInfo.fieldClass) != EnumSerializer.instance) {
                  asm = false;
                  break;
               }

               JSONField annotation = fieldInfo.getAnnotation();
               if (annotation != null) {
                  String format = annotation.format();
                  if (format.length() != 0 && (fieldInfo.fieldClass != String.class || !"trim".equals(format))) {
                     asm = false;
                     break;
                  }

                  if (!ASMUtils.checkName(annotation.name()) || annotation.jsonDirect() || annotation.serializeUsing() != Void.class || annotation.unwrapped()) {
                     asm = false;
                     break;
                  }

                  SerializerFeature[] var13 = annotation.serialzeFeatures();
                  int var14 = var13.length;
                  int var15 = 0;

                  while(true) {
                     if (var15 < var14) {
                        SerializerFeature feature = var13[var15];
                        if (SerializerFeature.WriteNonStringValueAsString != feature && SerializerFeature.WriteEnumUsingToString != feature && SerializerFeature.NotWriteDefaultValue != feature && SerializerFeature.BrowserCompatible != feature && SerializerFeature.WriteClassName != feature) {
                           ++var15;
                           continue;
                        }

                        asm = false;
                     }

                     if (TypeUtils.isAnnotationPresentOneToMany(method) || TypeUtils.isAnnotationPresentManyToMany(method)) {
                        asm = false;
                        break label172;
                     }

                     if (annotation.defaultValue() != null && !"".equals(annotation.defaultValue())) {
                        asm = false;
                        break label172;
                     }
                     break;
                  }
               }
            }
         }

         if (asm) {
            try {
               ObjectSerializer asmSerializer = this.createASMSerializer(beanInfo);
               if (asmSerializer != null) {
                  return asmSerializer;
               }
            } catch (ClassNotFoundException var18) {
            } catch (ClassFormatError var19) {
            } catch (ClassCastException var20) {
            } catch (OutOfMemoryError e) {
               if (e.getMessage().indexOf("Metaspace") != -1) {
                  throw e;
               }
            } catch (Throwable e) {
               throw new JSONException("create asm serializer error, verson 1.2.84, class " + clazz, e);
            }
         }

         return new JavaBeanSerializer(beanInfo);
      }
   }

   public boolean isAsmEnable() {
      return this.asm;
   }

   public void setAsmEnable(boolean asmEnable) {
      if (!ASMUtils.IS_ANDROID) {
         this.asm = asmEnable;
      }
   }

   public static SerializeConfig getGlobalInstance() {
      return globalInstance;
   }

   public SerializeConfig() {
      this(8192);
   }

   public SerializeConfig(boolean fieldBase) {
      this(8192, fieldBase);
   }

   public SerializeConfig(int tableSize) {
      this(tableSize, false);
   }

   public SerializeConfig(int tableSize, boolean fieldBase) {
      this.asm = !ASMUtils.IS_ANDROID;
      this.typeKey = JSON.DEFAULT_TYPE_KEY;
      this.denyClasses = new long[]{4165360493669296979L, 4446674157046724083L};
      this.modules = new ArrayList();
      this.fieldBased = fieldBase;
      this.serializers = new IdentityHashMap<Type, ObjectSerializer>(tableSize);
      this.mixInSerializers = new IdentityHashMap<Type, IdentityHashMap<Type, ObjectSerializer>>(16);

      try {
         if (this.asm) {
            this.asmFactory = new ASMSerializerFactory();
         }
      } catch (Throwable var4) {
         this.asm = false;
      }

      this.initSerializers();
   }

   private void initSerializers() {
      this.put((Type)Boolean.class, (ObjectSerializer)BooleanCodec.instance);
      this.put((Type)Character.class, (ObjectSerializer)CharacterCodec.instance);
      this.put((Type)Byte.class, (ObjectSerializer)IntegerCodec.instance);
      this.put((Type)Short.class, (ObjectSerializer)IntegerCodec.instance);
      this.put((Type)Integer.class, (ObjectSerializer)IntegerCodec.instance);
      this.put((Type)Long.class, (ObjectSerializer)LongCodec.instance);
      this.put((Type)Float.class, (ObjectSerializer)FloatCodec.instance);
      this.put((Type)Double.class, (ObjectSerializer)DoubleSerializer.instance);
      this.put((Type)BigDecimal.class, (ObjectSerializer)BigDecimalCodec.instance);
      this.put((Type)BigInteger.class, (ObjectSerializer)BigIntegerCodec.instance);
      this.put((Type)String.class, (ObjectSerializer)StringCodec.instance);
      this.put((Type)byte[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)short[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)int[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)long[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)float[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)double[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)boolean[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)char[].class, (ObjectSerializer)PrimitiveArraySerializer.instance);
      this.put((Type)Object[].class, (ObjectSerializer)ObjectArrayCodec.instance);
      this.put((Type)Class.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)SimpleDateFormat.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)Currency.class, (ObjectSerializer)(new MiscCodec()));
      this.put((Type)TimeZone.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)InetAddress.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)Inet4Address.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)Inet6Address.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)InetSocketAddress.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)File.class, (ObjectSerializer)MiscCodec.instance);
      this.put((Type)Appendable.class, (ObjectSerializer)AppendableSerializer.instance);
      this.put((Type)StringBuffer.class, (ObjectSerializer)AppendableSerializer.instance);
      this.put((Type)StringBuilder.class, (ObjectSerializer)AppendableSerializer.instance);
      this.put((Type)Charset.class, (ObjectSerializer)ToStringSerializer.instance);
      this.put((Type)Pattern.class, (ObjectSerializer)ToStringSerializer.instance);
      this.put((Type)Locale.class, (ObjectSerializer)ToStringSerializer.instance);
      this.put((Type)URI.class, (ObjectSerializer)ToStringSerializer.instance);
      this.put((Type)URL.class, (ObjectSerializer)ToStringSerializer.instance);
      this.put((Type)UUID.class, (ObjectSerializer)ToStringSerializer.instance);
      this.put((Type)AtomicBoolean.class, (ObjectSerializer)AtomicCodec.instance);
      this.put((Type)AtomicInteger.class, (ObjectSerializer)AtomicCodec.instance);
      this.put((Type)AtomicLong.class, (ObjectSerializer)AtomicCodec.instance);
      this.put((Type)AtomicReference.class, (ObjectSerializer)ReferenceCodec.instance);
      this.put((Type)AtomicIntegerArray.class, (ObjectSerializer)AtomicCodec.instance);
      this.put((Type)AtomicLongArray.class, (ObjectSerializer)AtomicCodec.instance);
      this.put((Type)WeakReference.class, (ObjectSerializer)ReferenceCodec.instance);
      this.put((Type)SoftReference.class, (ObjectSerializer)ReferenceCodec.instance);
      this.put((Type)LinkedList.class, (ObjectSerializer)CollectionCodec.instance);
   }

   public void addFilter(Class<?> clazz, SerializeFilter filter) {
      ObjectSerializer serializer = this.getObjectWriter(clazz);
      if (serializer instanceof SerializeFilterable) {
         SerializeFilterable filterable = (SerializeFilterable)serializer;
         if (this != globalInstance && filterable == MapSerializer.instance) {
            MapSerializer newMapSer = new MapSerializer();
            this.put((Type)clazz, (ObjectSerializer)newMapSer);
            newMapSer.addFilter(filter);
            return;
         }

         filterable.addFilter(filter);
      }

   }

   public void config(Class<?> clazz, SerializerFeature feature, boolean value) {
      ObjectSerializer serializer = this.getObjectWriter(clazz, false);
      if (serializer == null) {
         SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, (Map)null, this.propertyNamingStrategy);
         if (value) {
            beanInfo.features |= feature.mask;
         } else {
            beanInfo.features &= ~feature.mask;
         }

         serializer = this.createJavaBeanSerializer(beanInfo);
         this.put((Type)clazz, (ObjectSerializer)serializer);
      } else {
         if (serializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer;
            SerializeBeanInfo beanInfo = javaBeanSerializer.beanInfo;
            int originalFeaturs = beanInfo.features;
            if (value) {
               beanInfo.features |= feature.mask;
            } else {
               beanInfo.features &= ~feature.mask;
            }

            if (originalFeaturs == beanInfo.features) {
               return;
            }

            Class<?> serializerClass = serializer.getClass();
            if (serializerClass != JavaBeanSerializer.class) {
               ObjectSerializer newSerializer = this.createJavaBeanSerializer(beanInfo);
               this.put((Type)clazz, (ObjectSerializer)newSerializer);
            }
         }

      }
   }

   public ObjectSerializer getObjectWriter(Class<?> clazz) {
      return this.getObjectWriter(clazz, true);
   }

   public ObjectSerializer getObjectWriter(Class<?> clazz, boolean create) {
      ObjectSerializer writer = this.get(clazz);
      if (writer != null) {
         return writer;
      } else {
         try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

            for(Object o : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
               if (o instanceof AutowiredObjectSerializer) {
                  AutowiredObjectSerializer autowired = (AutowiredObjectSerializer)o;

                  for(Type forType : autowired.getAutowiredFor()) {
                     this.put((Type)forType, (ObjectSerializer)autowired);
                  }
               }
            }
         } catch (ClassCastException var17) {
         }

         writer = this.get(clazz);
         if (writer == null) {
            ClassLoader classLoader = JSON.class.getClassLoader();
            if (classLoader != Thread.currentThread().getContextClassLoader()) {
               try {
                  for(Object o : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
                     if (o instanceof AutowiredObjectSerializer) {
                        AutowiredObjectSerializer autowired = (AutowiredObjectSerializer)o;

                        for(Type forType : autowired.getAutowiredFor()) {
                           this.put((Type)forType, (ObjectSerializer)autowired);
                        }
                     }
                  }
               } catch (ClassCastException var16) {
               }

               writer = this.get(clazz);
            }
         }

         for(Module module : this.modules) {
            writer = module.createSerializer(this, clazz);
            if (writer != null) {
               this.put((Type)clazz, (ObjectSerializer)writer);
               return writer;
            }
         }

         if (writer == null) {
            String className = clazz.getName();
            if (Map.class.isAssignableFrom(clazz)) {
               this.put((Type)clazz, (ObjectSerializer)(writer = MapSerializer.instance));
            } else if (List.class.isAssignableFrom(clazz)) {
               this.put((Type)clazz, (ObjectSerializer)(writer = ListSerializer.instance));
            } else if (Collection.class.isAssignableFrom(clazz)) {
               this.put((Type)clazz, (ObjectSerializer)(writer = CollectionCodec.instance));
            } else if (Date.class.isAssignableFrom(clazz)) {
               this.put((Type)clazz, (ObjectSerializer)(writer = DateCodec.instance));
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
               this.put((Type)clazz, (ObjectSerializer)(writer = JSONAwareSerializer.instance));
            } else if (JSONSerializable.class.isAssignableFrom(clazz)) {
               this.put((Type)clazz, (ObjectSerializer)(writer = JSONSerializableSerializer.instance));
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
               this.put((Type)clazz, (ObjectSerializer)(writer = MiscCodec.instance));
            } else if (clazz.isEnum()) {
               Class mixedInType = (Class)JSON.getMixInAnnotations(clazz);
               JSONType jsonType;
               if (mixedInType != null) {
                  jsonType = (JSONType)TypeUtils.getAnnotation(mixedInType, JSONType.class);
               } else {
                  jsonType = (JSONType)TypeUtils.getAnnotation(clazz, JSONType.class);
               }

               if (jsonType != null && jsonType.serializeEnumAsJavaBean()) {
                  this.put((Type)clazz, (ObjectSerializer)(writer = this.createJavaBeanSerializer(clazz)));
               } else {
                  Member member = null;
                  if (mixedInType != null) {
                     Member mixedInMember = getEnumValueField(mixedInType);
                     if (mixedInMember != null) {
                        try {
                           if (mixedInMember instanceof Method) {
                              Method mixedInMethod = (Method)mixedInMember;
                              member = clazz.getMethod(mixedInMethod.getName(), mixedInMethod.getParameterTypes());
                           }
                        } catch (Exception var12) {
                        }
                     }
                  } else {
                     member = getEnumValueField(clazz);
                  }

                  if (member != null) {
                     this.put((Type)clazz, (ObjectSerializer)(writer = new EnumSerializer(member)));
                  } else {
                     this.put((Type)clazz, (ObjectSerializer)(writer = this.getEnumSerializer()));
                  }
               }
            } else {
               Class<?> superClass;
               if ((superClass = clazz.getSuperclass()) != null && superClass.isEnum()) {
                  JSONType jsonType = (JSONType)TypeUtils.getAnnotation(superClass, JSONType.class);
                  if (jsonType != null && jsonType.serializeEnumAsJavaBean()) {
                     this.put((Type)clazz, (ObjectSerializer)(writer = this.createJavaBeanSerializer(clazz)));
                  } else {
                     this.put((Type)clazz, (ObjectSerializer)(writer = this.getEnumSerializer()));
                  }
               } else if (clazz.isArray()) {
                  Class<?> componentType = clazz.getComponentType();
                  ObjectSerializer compObjectSerializer = this.getObjectWriter(componentType);
                  this.put((Type)clazz, (ObjectSerializer)(writer = new ArraySerializer(componentType, compObjectSerializer)));
               } else if (Throwable.class.isAssignableFrom(clazz)) {
                  SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, (Map)null, this.propertyNamingStrategy);
                  beanInfo.features |= SerializerFeature.WriteClassName.mask;
                  this.put((Type)clazz, (ObjectSerializer)(writer = new JavaBeanSerializer(beanInfo)));
               } else if (!TimeZone.class.isAssignableFrom(clazz) && !Map.Entry.class.isAssignableFrom(clazz)) {
                  if (Appendable.class.isAssignableFrom(clazz)) {
                     this.put((Type)clazz, (ObjectSerializer)(writer = AppendableSerializer.instance));
                  } else if (Charset.class.isAssignableFrom(clazz)) {
                     this.put((Type)clazz, (ObjectSerializer)(writer = ToStringSerializer.instance));
                  } else if (Enumeration.class.isAssignableFrom(clazz)) {
                     this.put((Type)clazz, (ObjectSerializer)(writer = EnumerationSerializer.instance));
                  } else if (!Calendar.class.isAssignableFrom(clazz) && !XMLGregorianCalendar.class.isAssignableFrom(clazz)) {
                     if (TypeUtils.isClob(clazz)) {
                        this.put((Type)clazz, (ObjectSerializer)(writer = ClobSerializer.instance));
                     } else if (TypeUtils.isPath(clazz)) {
                        this.put((Type)clazz, (ObjectSerializer)(writer = ToStringSerializer.instance));
                     } else if (Iterator.class.isAssignableFrom(clazz)) {
                        this.put((Type)clazz, (ObjectSerializer)(writer = MiscCodec.instance));
                     } else if (Node.class.isAssignableFrom(clazz)) {
                        this.put((Type)clazz, (ObjectSerializer)(writer = MiscCodec.instance));
                     } else {
                        if (className.startsWith("java.awt.") && AwtCodec.support(clazz) && !awtError) {
                           try {
                              String[] names = new String[]{"java.awt.Color", "java.awt.Font", "java.awt.Point", "java.awt.Rectangle"};

                              for(String name : names) {
                                 if (name.equals(className)) {
                                    this.put((Type)Class.forName(name), (ObjectSerializer)(writer = AwtCodec.instance));
                                    return writer;
                                 }
                              }
                           } catch (Throwable var15) {
                              awtError = true;
                           }
                        }

                        if (!jdk8Error && (className.startsWith("java.time.") || className.startsWith("java.util.Optional") || className.equals("java.util.concurrent.atomic.LongAdder") || className.equals("java.util.concurrent.atomic.DoubleAdder"))) {
                           try {
                              String[] names = new String[]{"java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.ZoneOffset", "java.time.ZoneRegion", "java.time.Period", "java.time.Duration", "java.time.Instant"};

                              for(String name : names) {
                                 if (name.equals(className)) {
                                    this.put((Type)Class.forName(name), (ObjectSerializer)(writer = Jdk8DateCodec.instance));
                                    return writer;
                                 }
                              }

                              names = new String[]{"java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong"};

                              for(String name : names) {
                                 if (name.equals(className)) {
                                    this.put((Type)Class.forName(name), (ObjectSerializer)(writer = OptionalCodec.instance));
                                    return writer;
                                 }
                              }

                              names = new String[]{"java.util.concurrent.atomic.LongAdder", "java.util.concurrent.atomic.DoubleAdder"};

                              for(String name : names) {
                                 if (name.equals(className)) {
                                    this.put((Type)Class.forName(name), (ObjectSerializer)(writer = AdderSerializer.instance));
                                    return writer;
                                 }
                              }
                           } catch (Throwable var14) {
                              jdk8Error = true;
                           }
                        }

                        if (!oracleJdbcError && className.startsWith("oracle.sql.")) {
                           try {
                              String[] names = new String[]{"oracle.sql.DATE", "oracle.sql.TIMESTAMP"};

                              for(String name : names) {
                                 if (name.equals(className)) {
                                    this.put((Type)Class.forName(name), (ObjectSerializer)(writer = DateCodec.instance));
                                    return writer;
                                 }
                              }
                           } catch (Throwable var13) {
                              oracleJdbcError = true;
                           }
                        }

                        if (!springfoxError && className.equals("springfox.documentation.spring.web.json.Json")) {
                        }

                        if (!guavaError && className.startsWith("com.google.common.collect.")) {
                        }

                        if (className.equals("net.sf.json.JSONNull")) {
                           this.put((Type)clazz, (ObjectSerializer)(writer = MiscCodec.instance));
                           return writer;
                        }

                        if (className.equals("org.json.JSONObject")) {
                           this.put((Type)clazz, (ObjectSerializer)(writer = JSONObjectCodec.instance));
                           return writer;
                        }

                        if (!jodaError && className.startsWith("org.joda.")) {
                        }

                        if ("java.nio.HeapByteBuffer".equals(className)) {
                           this.put((Type)clazz, (ObjectSerializer)(writer = ByteBufferCodec.instance));
                           return writer;
                        }

                        if ("org.javamoney.moneta.Money".equals(className)) {
                        }

                        if ("com.google.protobuf.Descriptors$FieldDescriptor".equals(className)) {
                        }

                        Class[] interfaces = clazz.getInterfaces();
                        if (interfaces.length == 1 && interfaces[0].isAnnotation()) {
                           this.put((Type)clazz, (ObjectSerializer)AnnotationSerializer.instance);
                           return AnnotationSerializer.instance;
                        }

                        if (TypeUtils.isProxy(clazz)) {
                           Class<?> superClazz = clazz.getSuperclass();
                           ObjectSerializer superWriter = this.getObjectWriter(superClazz);
                           this.put((Type)clazz, (ObjectSerializer)superWriter);
                           return superWriter;
                        }

                        if (Proxy.isProxyClass(clazz)) {
                           Class handlerClass = null;
                           if (interfaces.length == 2) {
                              handlerClass = interfaces[1];
                           } else {
                              for(Class proxiedInterface : interfaces) {
                                 if (!proxiedInterface.getName().startsWith("org.springframework.aop.")) {
                                    if (handlerClass != null) {
                                       handlerClass = null;
                                       break;
                                    }

                                    handlerClass = proxiedInterface;
                                 }
                              }
                           }

                           if (handlerClass != null) {
                              ObjectSerializer superWriter = this.getObjectWriter(handlerClass);
                              this.put((Type)clazz, (ObjectSerializer)superWriter);
                              return superWriter;
                           }
                        }

                        if (create) {
                           writer = this.createJavaBeanSerializer(clazz);
                           this.put((Type)clazz, (ObjectSerializer)writer);
                        }
                     }
                  } else {
                     this.put((Type)clazz, (ObjectSerializer)(writer = CalendarCodec.instance));
                  }
               } else {
                  this.put((Type)clazz, (ObjectSerializer)(writer = MiscCodec.instance));
               }
            }

            if (writer == null) {
               writer = this.get(clazz);
            }
         }

         return writer;
      }
   }

   private static Member getEnumValueField(Class clazz) {
      Member member = null;
      Method[] methods = clazz.getMethods();

      for(Method method : methods) {
         if (method.getReturnType() != Void.class) {
            JSONField jsonField = (JSONField)method.getAnnotation(JSONField.class);
            if (jsonField != null) {
               if (member != null) {
                  return null;
               }

               member = method;
            }
         }
      }

      for(Field field : clazz.getFields()) {
         JSONField jsonField = (JSONField)field.getAnnotation(JSONField.class);
         if (jsonField != null) {
            if (member != null) {
               return null;
            }

            member = field;
         }
      }

      return member;
   }

   protected ObjectSerializer getEnumSerializer() {
      return EnumSerializer.instance;
   }

   public final ObjectSerializer get(Type type) {
      Type mixin = JSON.getMixInAnnotations(type);
      if (null == mixin) {
         return this.serializers.get(type);
      } else {
         IdentityHashMap<Type, ObjectSerializer> mixInClasses = this.mixInSerializers.get(type);
         return mixInClasses == null ? null : (ObjectSerializer)mixInClasses.get(mixin);
      }
   }

   public boolean put(Object type, Object value) {
      return this.put((Type)type, (ObjectSerializer)value);
   }

   public boolean put(Type type, ObjectSerializer value) {
      Type mixin = JSON.getMixInAnnotations(type);
      if (mixin != null) {
         IdentityHashMap<Type, ObjectSerializer> mixInClasses = this.mixInSerializers.get(type);
         if (mixInClasses == null) {
            mixInClasses = new IdentityHashMap<Type, ObjectSerializer>(4);
            this.mixInSerializers.put(type, mixInClasses);
         }

         return mixInClasses.put(mixin, value);
      } else {
         return this.serializers.put(type, value);
      }
   }

   public void configEnumAsJavaBean(Class<? extends Enum>... enumClasses) {
      for(Class<? extends Enum> enumClass : enumClasses) {
         this.put((Type)enumClass, (ObjectSerializer)this.createJavaBeanSerializer(enumClass));
      }

   }

   public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
      this.propertyNamingStrategy = propertyNamingStrategy;
   }

   public void clearSerializers() {
      this.serializers.clear();
      this.initSerializers();
   }

   public void register(Module module) {
      this.modules.add(module);
   }
}
