package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class StringCodec implements ObjectSerializer, ObjectDeserializer {
   public static StringCodec instance = new StringCodec();

   public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
      this.write(serializer, (String)object);
   }

   public void write(JSONSerializer serializer, String value) {
      SerializeWriter out = serializer.out;
      if (value == null) {
         out.writeNull(SerializerFeature.WriteNullStringAsEmpty);
      } else {
         out.writeString(value);
      }
   }

   public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
      if (clazz == StringBuffer.class) {
         JSONLexer lexer = parser.lexer;
         if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)(new StringBuffer(val));
         } else {
            Object value = parser.parse();
            return (T)(value == null ? null : new StringBuffer(value.toString()));
         }
      } else if (clazz == StringBuilder.class) {
         JSONLexer lexer = parser.lexer;
         if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)(new StringBuilder(val));
         } else {
            Object value = parser.parse();
            return (T)(value == null ? null : new StringBuilder(value.toString()));
         }
      } else {
         return (T)deserialze(parser);
      }
   }

   public static <T> T deserialze(DefaultJSONParser parser) {
      JSONLexer lexer = parser.getLexer();
      if (lexer.token() == 4) {
         String val = lexer.stringVal();
         lexer.nextToken(16);
         return (T)val;
      } else if (lexer.token() == 2) {
         String val = lexer.numberString();
         lexer.nextToken(16);
         return (T)val;
      } else {
         Object value = parser.parse();
         return (T)(value == null ? null : value.toString());
      }
   }

   public int getFastMatchToken() {
      return 4;
   }
}
