package com.alibaba.fastjson.support.geo;

import com.alibaba.fastjson.annotation.JSONType;
import java.util.LinkedHashMap;
import java.util.Map;

@JSONType(
   typeName = "Feature",
   orders = {"type", "id", "bbox", "coordinates", "properties"}
)
public class Feature extends Geometry {
   private String id;
   private Geometry geometry;
   private Map<String, String> properties = new LinkedHashMap();

   public Feature() {
      super("Feature");
   }

   public Geometry getGeometry() {
      return this.geometry;
   }

   public void setGeometry(Geometry geometry) {
      this.geometry = geometry;
   }

   public Map<String, String> getProperties() {
      return this.properties;
   }

   public void setProperties(Map<String, String> properties) {
      this.properties = properties;
   }

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }
}
