package com.alibaba.fastjson.support.hsf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class HSFJSONUtils {
   static final SymbolTable typeSymbolTable = new SymbolTable(1024);
   static final char[] fieldName_argsTypes = "\"argsTypes\"".toCharArray();
   static final char[] fieldName_argsObjs = "\"argsObjs\"".toCharArray();
   static final char[] fieldName_type = "\"@type\":".toCharArray();

   public static Object[] parseInvocationArguments(String json, MethodLocator methodLocator) {
      DefaultJSONParser parser = new DefaultJSONParser(json);
      JSONLexerBase lexer = (JSONLexerBase)parser.getLexer();
      ParseContext rootContext = parser.setContext(null, null);
      int token = lexer.token();
      Object[] values;
      if (token == 12) {
         String[] typeNames = lexer.scanFieldStringArray(fieldName_argsTypes, -1, typeSymbolTable);
         if (typeNames == null && lexer.matchStat == -2) {
            String type = lexer.scanFieldString(fieldName_type);
            if ("com.alibaba.fastjson.JSONObject".equals(type)) {
               typeNames = lexer.scanFieldStringArray(fieldName_argsTypes, -1, typeSymbolTable);
            }
         }

         Method method = methodLocator.findMethod(typeNames);
         if (method == null) {
            lexer.close();
            JSONObject jsonObject = JSON.parseObject(json);
            typeNames = (String[])jsonObject.getObject("argsTypes", String[].class);
            method = methodLocator.findMethod(typeNames);
            JSONArray argsObjs = jsonObject.getJSONArray("argsObjs");
            if (argsObjs == null) {
               values = null;
            } else {
               Type[] argTypes = method.getGenericParameterTypes();
               values = new Object[argTypes.length];

               for(int i = 0; i < argTypes.length; ++i) {
                  Type type = argTypes[i];
                  values[i] = argsObjs.getObject(i, type);
               }
            }
         } else {
            Type[] argTypes = method.getGenericParameterTypes();
            lexer.skipWhitespace();
            if (lexer.getCurrent() == ',') {
               lexer.next();
            }

            if (lexer.matchField2(fieldName_argsObjs)) {
               lexer.nextToken();
               ParseContext context = parser.setContext(rootContext, null, "argsObjs");
               values = parser.parseArray(argTypes);
               context.object = values;
               parser.accept(13);
               parser.handleResovleTask(null);
            } else {
               values = null;
            }

            parser.close();
         }
      } else if (token == 14) {
         String[] typeNames = lexer.scanFieldStringArray((char[])null, -1, typeSymbolTable);
         lexer.skipWhitespace();
         char ch = lexer.getCurrent();
         if (ch == ']') {
            Method method = methodLocator.findMethod((String[])null);
            Type[] argTypes = method.getGenericParameterTypes();
            values = new Object[typeNames.length];

            for(int i = 0; i < typeNames.length; ++i) {
               Type argType = argTypes[i];
               String typeName = typeNames[i];
               if (argType != String.class) {
                  values[i] = TypeUtils.cast(typeName, argType, parser.getConfig());
               } else {
                  values[i] = typeName;
               }
            }

            return values;
         }

         if (ch == ',') {
            lexer.next();
            lexer.skipWhitespace();
         }

         lexer.nextToken(14);
         Method method = methodLocator.findMethod(typeNames);
         Type[] argTypes = method.getGenericParameterTypes();
         values = parser.parseArray(argTypes);
         lexer.close();
      } else {
         values = null;
      }

      return values;
   }
}
