package com.alibaba.fastjson.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;

/** @deprecated */
public class AntiCollisionHashMap<K, V> extends AbstractMap<K, V> implements Map<K, V>, Cloneable, Serializable {
   transient volatile Set<K> keySet;
   transient volatile Collection<V> values;
   static final int DEFAULT_INITIAL_CAPACITY = 16;
   static final int MAXIMUM_CAPACITY = 1073741824;
   static final float DEFAULT_LOAD_FACTOR = 0.75F;
   transient Entry<K, V>[] table;
   transient int size;
   int threshold;
   final float loadFactor;
   transient volatile int modCount;
   static final int M_MASK = -2023358765;
   static final int SEED = -2128831035;
   static final int KEY = 16777619;
   final int random;
   private transient Set<Map.Entry<K, V>> entrySet;
   private static final long serialVersionUID = 362498820763181265L;

   private int hashString(String key) {
      int hash = -2128831035 * this.random;

      for(int i = 0; i < key.length(); ++i) {
         hash = hash * 16777619 ^ key.charAt(i);
      }

      return (hash ^ hash >> 1) & -2023358765;
   }

   public AntiCollisionHashMap(int initialCapacity, float loadFactor) {
      this.keySet = null;
      this.values = null;
      this.random = (new Random()).nextInt(99999);
      this.entrySet = null;
      if (initialCapacity < 0) {
         throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
      } else {
         if (initialCapacity > 1073741824) {
            initialCapacity = 1073741824;
         }

         if (!(loadFactor <= 0.0F) && !Float.isNaN(loadFactor)) {
            int capacity;
            for(capacity = 1; capacity < initialCapacity; capacity <<= 1) {
            }

            this.loadFactor = loadFactor;
            this.threshold = (int)((float)capacity * loadFactor);
            this.table = new Entry[capacity];
            this.init();
         } else {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
         }
      }
   }

   public AntiCollisionHashMap(int initialCapacity) {
      this(initialCapacity, 0.75F);
   }

   public AntiCollisionHashMap() {
      this.keySet = null;
      this.values = null;
      this.random = (new Random()).nextInt(99999);
      this.entrySet = null;
      this.loadFactor = 0.75F;
      this.threshold = 12;
      this.table = new Entry[16];
      this.init();
   }

   public AntiCollisionHashMap(Map<? extends K, ? extends V> m) {
      this(Math.max((int)((float)m.size() / 0.75F) + 1, 16), 0.75F);
      this.putAllForCreate(m);
   }

   void init() {
   }

   static int hash(int h) {
      h *= h;
      h ^= h >>> 20 ^ h >>> 12;
      return h ^ h >>> 7 ^ h >>> 4;
   }

   static int indexFor(int h, int length) {
      return h & length - 1;
   }

   public int size() {
      return this.size;
   }

   public boolean isEmpty() {
      return this.size == 0;
   }

   public V get(Object key) {
      if (key == null) {
         return (V)this.getForNullKey();
      } else {
         int hash = 0;
         if (key instanceof String) {
            hash = hash(this.hashString((String)key));
         } else {
            hash = hash(key.hashCode());
         }

         for(Entry<K, V> e = this.table[indexFor(hash, this.table.length)]; e != null; e = e.next) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
               return e.value;
            }
         }

         return null;
      }
   }

   private V getForNullKey() {
      for(Entry<K, V> e = this.table[0]; e != null; e = e.next) {
         if (e.key == null) {
            return e.value;
         }
      }

      return null;
   }

   public boolean containsKey(Object key) {
      return this.getEntry(key) != null;
   }

   final Entry<K, V> getEntry(Object key) {
      int hash = key == null ? 0 : (key instanceof String ? hash(this.hashString((String)key)) : hash(key.hashCode()));

      for(Entry<K, V> e = this.table[indexFor(hash, this.table.length)]; e != null; e = e.next) {
         Object k;
         if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
            return e;
         }
      }

      return null;
   }

   public V put(K key, V value) {
      if (key == null) {
         return (V)this.putForNullKey(value);
      } else {
         int hash = 0;
         if (key instanceof String) {
            hash = hash(this.hashString((String)key));
         } else {
            hash = hash(key.hashCode());
         }

         int i = indexFor(hash, this.table.length);

         for(Entry<K, V> e = this.table[i]; e != null; e = e.next) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
               V oldValue = e.value;
               e.value = value;
               return oldValue;
            }
         }

         ++this.modCount;
         this.addEntry(hash, key, value, i);
         return null;
      }
   }

   private V putForNullKey(V value) {
      for(Entry<K, V> e = this.table[0]; e != null; e = e.next) {
         if (e.key == null) {
            V oldValue = e.value;
            e.value = value;
            return oldValue;
         }
      }

      ++this.modCount;
      this.addEntry(0, null, value, 0);
      return null;
   }

   private void putForCreate(K key, V value) {
      int hash = key == null ? 0 : (key instanceof String ? hash(this.hashString((String)key)) : hash(key.hashCode()));
      int i = indexFor(hash, this.table.length);

      for(Entry<K, V> e = this.table[i]; e != null; e = e.next) {
         Object k;
         if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
            e.value = value;
            return;
         }
      }

      this.createEntry(hash, key, value, i);
   }

   private void putAllForCreate(Map<? extends K, ? extends V> m) {
      for(Map.Entry<? extends K, ? extends V> e : m.entrySet()) {
         this.putForCreate(e.getKey(), e.getValue());
      }

   }

   void resize(int newCapacity) {
      Entry<K, V>[] oldTable = this.table;
      int oldCapacity = oldTable.length;
      if (oldCapacity == 1073741824) {
         this.threshold = Integer.MAX_VALUE;
      } else {
         Entry<K, V>[] newTable = new Entry[newCapacity];
         this.transfer(newTable);
         this.table = newTable;
         this.threshold = (int)((float)newCapacity * this.loadFactor);
      }
   }

   void transfer(Entry[] newTable) {
      Entry[] src = this.table;
      int newCapacity = newTable.length;

      for(int j = 0; j < src.length; ++j) {
         Entry<K, V> e = src[j];
         if (e != null) {
            src[j] = null;

            while(true) {
               Entry<K, V> next = e.next;
               int i = indexFor(e.hash, newCapacity);
               e.next = newTable[i];
               newTable[i] = e;
               e = next;
               if (next == null) {
                  break;
               }
            }
         }
      }

   }

   public void putAll(Map<? extends K, ? extends V> m) {
      int numKeysToBeAdded = m.size();
      if (numKeysToBeAdded != 0) {
         if (numKeysToBeAdded > this.threshold) {
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0F);
            if (targetCapacity > 1073741824) {
               targetCapacity = 1073741824;
            }

            int newCapacity;
            for(newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }

            if (newCapacity > this.table.length) {
               this.resize(newCapacity);
            }
         }

         for(Map.Entry<? extends K, ? extends V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
         }

      }
   }

   public V remove(Object key) {
      Entry<K, V> e = this.removeEntryForKey(key);
      return (V)(e == null ? null : e.value);
   }

   final Entry<K, V> removeEntryForKey(Object key) {
      int hash = key == null ? 0 : (key instanceof String ? hash(this.hashString((String)key)) : hash(key.hashCode()));
      int i = indexFor(hash, this.table.length);
      Entry<K, V> prev = this.table[i];

      Entry<K, V> e;
      Entry<K, V> next;
      for(e = prev; e != null; e = next) {
         next = e.next;
         Object k;
         if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
            ++this.modCount;
            --this.size;
            if (prev == e) {
               this.table[i] = next;
            } else {
               prev.next = next;
            }

            return e;
         }

         prev = e;
      }

      return e;
   }

   final Entry<K, V> removeMapping(Object o) {
      if (!(o instanceof Map.Entry)) {
         return null;
      } else {
         Map.Entry<K, V> entry = (Map.Entry)o;
         Object key = entry.getKey();
         int hash = key == null ? 0 : (key instanceof String ? hash(this.hashString((String)key)) : hash(key.hashCode()));
         int i = indexFor(hash, this.table.length);
         Entry<K, V> prev = this.table[i];

         Entry<K, V> e;
         Entry<K, V> next;
         for(e = prev; e != null; e = next) {
            next = e.next;
            if (e.hash == hash && e.equals(entry)) {
               ++this.modCount;
               --this.size;
               if (prev == e) {
                  this.table[i] = next;
               } else {
                  prev.next = next;
               }

               return e;
            }

            prev = e;
         }

         return e;
      }
   }

   public void clear() {
      ++this.modCount;
      Entry[] tab = this.table;

      for(int i = 0; i < tab.length; ++i) {
         tab[i] = null;
      }

      this.size = 0;
   }

   public boolean containsValue(Object value) {
      if (value == null) {
         return this.containsNullValue();
      } else {
         Entry[] tab = this.table;

         for(int i = 0; i < tab.length; ++i) {
            for(Entry e = tab[i]; e != null; e = e.next) {
               if (value.equals(e.value)) {
                  return true;
               }
            }
         }

         return false;
      }
   }

   private boolean containsNullValue() {
      Entry[] tab = this.table;

      for(int i = 0; i < tab.length; ++i) {
         for(Entry e = tab[i]; e != null; e = e.next) {
            if (e.value == null) {
               return true;
            }
         }
      }

      return false;
   }

   public Object clone() {
      AntiCollisionHashMap<K, V> result = null;

      try {
         result = (AntiCollisionHashMap)super.clone();
      } catch (CloneNotSupportedException var3) {
      }

      result.table = new Entry[this.table.length];
      result.entrySet = null;
      result.modCount = 0;
      result.size = 0;
      result.init();
      result.putAllForCreate(this);
      return result;
   }

   void addEntry(int hash, K key, V value, int bucketIndex) {
      Entry<K, V> e = this.table[bucketIndex];
      this.table[bucketIndex] = new Entry(hash, key, value, e);
      if (this.size++ >= this.threshold) {
         this.resize(2 * this.table.length);
      }

   }

   void createEntry(int hash, K key, V value, int bucketIndex) {
      Entry<K, V> e = this.table[bucketIndex];
      this.table[bucketIndex] = new Entry(hash, key, value, e);
      ++this.size;
   }

   Iterator<K> newKeyIterator() {
      return new KeyIterator();
   }

   Iterator<V> newValueIterator() {
      return new ValueIterator();
   }

   Iterator<Map.Entry<K, V>> newEntryIterator() {
      return new EntryIterator();
   }

   public Set<K> keySet() {
      Set<K> ks = this.keySet;
      return ks != null ? ks : (this.keySet = new KeySet());
   }

   public Collection<V> values() {
      Collection<V> vs = this.values;
      return vs != null ? vs : (this.values = new Values());
   }

   public Set<Map.Entry<K, V>> entrySet() {
      return this.entrySet0();
   }

   private Set<Map.Entry<K, V>> entrySet0() {
      Set<Map.Entry<K, V>> es = this.entrySet;
      return es != null ? es : (this.entrySet = new EntrySet());
   }

   private void writeObject(ObjectOutputStream s) throws IOException {
      Iterator<Map.Entry<K, V>> i = this.size > 0 ? this.entrySet0().iterator() : null;
      s.defaultWriteObject();
      s.writeInt(this.table.length);
      s.writeInt(this.size);
      if (i != null) {
         while(i.hasNext()) {
            Map.Entry<K, V> e = (Map.Entry)i.next();
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
         }
      }

   }

   private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
      s.defaultReadObject();
      int numBuckets = s.readInt();
      this.table = new Entry[numBuckets];
      this.init();
      int size = s.readInt();

      for(int i = 0; i < size; ++i) {
         K key = (K)s.readObject();
         V value = (V)s.readObject();
         this.putForCreate(key, value);
      }

   }

   static class Entry<K, V> implements Map.Entry<K, V> {
      final K key;
      V value;
      Entry<K, V> next;
      final int hash;

      Entry(int h, K k, V v, Entry<K, V> n) {
         this.value = v;
         this.next = n;
         this.key = k;
         this.hash = h;
      }

      public final K getKey() {
         return this.key;
      }

      public final V getValue() {
         return this.value;
      }

      public final V setValue(V newValue) {
         V oldValue = this.value;
         this.value = newValue;
         return oldValue;
      }

      public final boolean equals(Object o) {
         if (!(o instanceof Map.Entry)) {
            return false;
         } else {
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            Object k2 = e.getKey();
            if (k1 == k2 || k1 != null && k1.equals(k2)) {
               Object v1 = this.getValue();
               Object v2 = e.getValue();
               return v1 == v2 || v1 != null && v1.equals(v2);
            } else {
               return false;
            }
         }
      }

      public final int hashCode() {
         return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
      }

      public final String toString() {
         return this.getKey() + "=" + this.getValue();
      }
   }

   private abstract class HashIterator<E> implements Iterator<E> {
      Entry<K, V> next;
      int expectedModCount;
      int index;
      Entry<K, V> current;

      HashIterator() {
         this.expectedModCount = AntiCollisionHashMap.this.modCount;
         if (AntiCollisionHashMap.this.size > 0) {
            Entry[] t = AntiCollisionHashMap.this.table;

            while(this.index < t.length && (this.next = t[this.index++]) == null) {
            }
         }

      }

      public final boolean hasNext() {
         return this.next != null;
      }

      final Entry<K, V> nextEntry() {
         if (AntiCollisionHashMap.this.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
         } else {
            Entry<K, V> e = this.next;
            if (e == null) {
               throw new NoSuchElementException();
            } else {
               if ((this.next = e.next) == null) {
                  Entry[] t = AntiCollisionHashMap.this.table;

                  while(this.index < t.length && (this.next = t[this.index++]) == null) {
                  }
               }

               this.current = e;
               return e;
            }
         }
      }

      public void remove() {
         if (this.current == null) {
            throw new IllegalStateException();
         } else if (AntiCollisionHashMap.this.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
         } else {
            Object k = this.current.key;
            this.current = null;
            AntiCollisionHashMap.this.removeEntryForKey(k);
            this.expectedModCount = AntiCollisionHashMap.this.modCount;
         }
      }
   }

   private final class ValueIterator extends HashIterator<V> {
      private ValueIterator() {
      }

      public V next() {
         return this.nextEntry().value;
      }
   }

   private final class KeyIterator extends HashIterator<K> {
      private KeyIterator() {
      }

      public K next() {
         return (K)this.nextEntry().getKey();
      }
   }

   private final class EntryIterator extends HashIterator<Map.Entry<K, V>> {
      private EntryIterator() {
      }

      public Map.Entry<K, V> next() {
         return this.nextEntry();
      }
   }

   private final class KeySet extends AbstractSet<K> {
      private KeySet() {
      }

      public Iterator<K> iterator() {
         return AntiCollisionHashMap.this.newKeyIterator();
      }

      public int size() {
         return AntiCollisionHashMap.this.size;
      }

      public boolean contains(Object o) {
         return AntiCollisionHashMap.this.containsKey(o);
      }

      public boolean remove(Object o) {
         return AntiCollisionHashMap.this.removeEntryForKey(o) != null;
      }

      public void clear() {
         AntiCollisionHashMap.this.clear();
      }
   }

   private final class Values extends AbstractCollection<V> {
      private Values() {
      }

      public Iterator<V> iterator() {
         return AntiCollisionHashMap.this.newValueIterator();
      }

      public int size() {
         return AntiCollisionHashMap.this.size;
      }

      public boolean contains(Object o) {
         return AntiCollisionHashMap.this.containsValue(o);
      }

      public void clear() {
         AntiCollisionHashMap.this.clear();
      }
   }

   private final class EntrySet extends AbstractSet<Map.Entry<K, V>> {
      private EntrySet() {
      }

      public Iterator<Map.Entry<K, V>> iterator() {
         return AntiCollisionHashMap.this.newEntryIterator();
      }

      public boolean contains(Object o) {
         if (!(o instanceof Map.Entry)) {
            return false;
         } else {
            Map.Entry<K, V> e = (Map.Entry)o;
            Entry<K, V> candidate = AntiCollisionHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
         }
      }

      public boolean remove(Object o) {
         return AntiCollisionHashMap.this.removeMapping(o) != null;
      }

      public int size() {
         return AntiCollisionHashMap.this.size;
      }

      public void clear() {
         AntiCollisionHashMap.this.clear();
      }
   }
}
