package com.alibaba.fastjson.util;

import java.util.Arrays;

public class IdentityHashMap<K, V> {
   private final Entry<K, V>[] buckets;
   private final int indexMask;
   public static final int DEFAULT_SIZE = 8192;

   public IdentityHashMap() {
      this(8192);
   }

   public IdentityHashMap(int tableSize) {
      this.indexMask = tableSize - 1;
      this.buckets = new Entry[tableSize];
   }

   public final V get(K key) {
      int hash = System.identityHashCode(key);
      int bucket = hash & this.indexMask;

      for(Entry<K, V> entry = this.buckets[bucket]; entry != null; entry = entry.next) {
         if (key == entry.key) {
            return entry.value;
         }
      }

      return null;
   }

   public Class findClass(String keyString) {
      for(int i = 0; i < this.buckets.length; ++i) {
         Entry bucket = this.buckets[i];
         if (bucket != null) {
            for(Entry<K, V> entry = bucket; entry != null; entry = entry.next) {
               Object key = bucket.key;
               if (key instanceof Class) {
                  Class clazz = (Class)key;
                  String className = clazz.getName();
                  if (className.equals(keyString)) {
                     return clazz;
                  }
               }
            }
         }
      }

      return null;
   }

   public boolean put(K key, V value) {
      int hash = System.identityHashCode(key);
      int bucket = hash & this.indexMask;

      for(Entry<K, V> entry = this.buckets[bucket]; entry != null; entry = entry.next) {
         if (key == entry.key) {
            entry.value = value;
            return true;
         }
      }

      Entry<K, V> entry = new Entry<K, V>(key, value, hash, this.buckets[bucket]);
      this.buckets[bucket] = entry;
      return false;
   }

   public void clear() {
      Arrays.fill(this.buckets, null);
   }

   public int size() {
      int count = 0;
      Entry[] var2 = this.buckets;
      int var3 = var2.length;

      for(int var4 = 0; var4 < var3; ++var4) {
         for(Entry<K, V> bucket = var2[var4]; bucket != null; bucket = bucket.next) {
            ++count;
         }
      }

      return count;
   }

   protected static final class Entry<K, V> {
      public final int hashCode;
      public final K key;
      public V value;
      public final Entry<K, V> next;

      public Entry(K key, V value, int hash, Entry<K, V> next) {
         this.key = key;
         this.value = value;
         this.next = next;
         this.hashCode = hash;
      }
   }
}
