package com.alibaba.fastjson.util;

import java.util.concurrent.Callable;

public class ModuleUtil {
   private static boolean hasJavaSql = false;

   public static <T> T callWhenHasJavaSql(Callable<T> callable) {
      if (hasJavaSql) {
         try {
            return (T)callable.call();
         } catch (Exception e) {
            throw new RuntimeException(e);
         }
      } else {
         return null;
      }
   }

   public static <ARG, T> T callWhenHasJavaSql(Function<ARG, T> callable, ARG arg) {
      return (T)(hasJavaSql ? callable.apply(arg) : null);
   }

   public static <T, U, R> R callWhenHasJavaSql(BiFunction<T, U, R> callable, T t, U u) {
      return (R)(hasJavaSql ? callable.apply(t, u) : null);
   }

   static {
      try {
         Class.forName("java.sql.Time");
         hasJavaSql = true;
      } catch (Throwable var1) {
         hasJavaSql = false;
      }

   }
}
