package com.alibaba.fastjson.util;

import java.math.BigInteger;

public final class RyuDouble {
   private static final int[][] POW5_SPLIT = new int[326][4];
   private static final int[][] POW5_INV_SPLIT = new int[291][4];

   public static String toString(double value) {
      char[] result = new char[24];
      int len = toString(value, result, 0);
      return new String(result, 0, len);
   }

   public static int toString(double value, char[] result, int off) {
      long DOUBLE_MANTISSA_MASK = 4503599627370495L;
      int DOUBLE_EXPONENT_MASK = 2047;
      int DOUBLE_EXPONENT_BIAS = 1023;
      long LOG10_5_NUMERATOR = 6989700L;
      long LOG10_2_NUMERATOR = 3010299L;
      int index = off;
      if (Double.isNaN(value)) {
         index = off + 1;
         result[off] = 'N';
         result[index++] = 'a';
         result[index++] = 'N';
         return index - off;
      } else if (value == Double.POSITIVE_INFINITY) {
         index = off + 1;
         result[off] = 'I';
         result[index++] = 'n';
         result[index++] = 'f';
         result[index++] = 'i';
         result[index++] = 'n';
         result[index++] = 'i';
         result[index++] = 't';
         result[index++] = 'y';
         return index - off;
      } else if (value == Double.NEGATIVE_INFINITY) {
         index = off + 1;
         result[off] = '-';
         result[index++] = 'I';
         result[index++] = 'n';
         result[index++] = 'f';
         result[index++] = 'i';
         result[index++] = 'n';
         result[index++] = 'i';
         result[index++] = 't';
         result[index++] = 'y';
         return index - off;
      } else {
         long bits = Double.doubleToLongBits(value);
         if (bits == 0L) {
            index = off + 1;
            result[off] = '0';
            result[index++] = '.';
            result[index++] = '0';
            return index - off;
         } else if (bits == Long.MIN_VALUE) {
            index = off + 1;
            result[off] = '-';
            result[index++] = '0';
            result[index++] = '.';
            result[index++] = '0';
            return index - off;
         } else {
            int DOUBLE_MANTISSA_BITS = 52;
            int ieeeExponent = (int)(bits >>> 52 & 2047L);
            long ieeeMantissa = bits & 4503599627370495L;
            int e2;
            long m2;
            if (ieeeExponent == 0) {
               e2 = -1074;
               m2 = ieeeMantissa;
            } else {
               e2 = ieeeExponent - 1023 - 52;
               m2 = ieeeMantissa | 4503599627370496L;
            }

            boolean sign = bits < 0L;
            boolean even = (m2 & 1L) == 0L;
            long mv = 4L * m2;
            long mp = 4L * m2 + 2L;
            int mmShift = m2 == 4503599627370496L && ieeeExponent > 1 ? 0 : 1;
            long mm = 4L * m2 - 1L - (long)mmShift;
            e2 -= 2;
            boolean dmIsTrailingZeros = false;
            boolean dvIsTrailingZeros = false;
            long dv;
            long dp;
            long dm;
            int e10;
            if (e2 >= 0) {
               int q = Math.max(0, (int)((long)e2 * 3010299L / 10000000L) - 1);
               int k = 122 + (q == 0 ? 1 : (int)(((long)q * 23219280L + 10000000L - 1L) / 10000000L)) - 1;
               int i = -e2 + q + k;
               int actualShift = i - 93 - 21;
               if (actualShift < 0) {
                  throw new IllegalArgumentException("" + actualShift);
               }

               int[] ints = POW5_INV_SPLIT[q];
               long mHigh = mv >>> 31;
               long mLow = mv & 2147483647L;
               long bits13 = mHigh * (long)ints[0];
               long bits03 = mLow * (long)ints[0];
               long bits12 = mHigh * (long)ints[1];
               long bits02 = mLow * (long)ints[1];
               long bits11 = mHigh * (long)ints[2];
               long bits01 = mLow * (long)ints[2];
               long bits10 = mHigh * (long)ints[3];
               long bits00 = mLow * (long)ints[3];
               dv = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
               mHigh = mp >>> 31;
               mLow = mp & 2147483647L;
               bits13 = mHigh * (long)ints[0];
               bits03 = mLow * (long)ints[0];
               bits12 = mHigh * (long)ints[1];
               bits02 = mLow * (long)ints[1];
               bits11 = mHigh * (long)ints[2];
               bits01 = mLow * (long)ints[2];
               bits10 = mHigh * (long)ints[3];
               bits00 = mLow * (long)ints[3];
               dp = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
               mHigh = mm >>> 31;
               mLow = mm & 2147483647L;
               bits13 = mHigh * (long)ints[0];
               bits03 = mLow * (long)ints[0];
               bits12 = mHigh * (long)ints[1];
               bits02 = mLow * (long)ints[1];
               bits11 = mHigh * (long)ints[2];
               bits01 = mLow * (long)ints[2];
               bits10 = mHigh * (long)ints[3];
               bits00 = mLow * (long)ints[3];
               dm = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
               e10 = q;
               if (q <= 21) {
                  if (mv % 5L == 0L) {
                     int pow5Factor_mv;
                     if (mv % 5L != 0L) {
                        pow5Factor_mv = 0;
                     } else if (mv % 25L != 0L) {
                        pow5Factor_mv = 1;
                     } else if (mv % 125L != 0L) {
                        pow5Factor_mv = 2;
                     } else if (mv % 625L != 0L) {
                        pow5Factor_mv = 3;
                     } else {
                        pow5Factor_mv = 4;

                        for(long v = mv / 625L; v > 0L && v % 5L == 0L; ++pow5Factor_mv) {
                           v /= 5L;
                        }
                     }

                     dvIsTrailingZeros = pow5Factor_mv >= q;
                  } else if (even) {
                     int pow5Factor_mm;
                     if (mm % 5L != 0L) {
                        pow5Factor_mm = 0;
                     } else if (mm % 25L != 0L) {
                        pow5Factor_mm = 1;
                     } else if (mm % 125L != 0L) {
                        pow5Factor_mm = 2;
                     } else if (mm % 625L != 0L) {
                        pow5Factor_mm = 3;
                     } else {
                        pow5Factor_mm = 4;

                        for(long v = mm / 625L; v > 0L && v % 5L == 0L; ++pow5Factor_mm) {
                           v /= 5L;
                        }
                     }

                     dmIsTrailingZeros = pow5Factor_mm >= q;
                  } else {
                     int pow5Factor_mp;
                     if (mp % 5L != 0L) {
                        pow5Factor_mp = 0;
                     } else if (mp % 25L != 0L) {
                        pow5Factor_mp = 1;
                     } else if (mp % 125L != 0L) {
                        pow5Factor_mp = 2;
                     } else if (mp % 625L != 0L) {
                        pow5Factor_mp = 3;
                     } else {
                        pow5Factor_mp = 4;

                        for(long v = mp / 625L; v > 0L && v % 5L == 0L; ++pow5Factor_mp) {
                           v /= 5L;
                        }
                     }

                     if (pow5Factor_mp >= q) {
                        --dp;
                     }
                  }
               }
            } else {
               int q = Math.max(0, (int)((long)(-e2) * 6989700L / 10000000L) - 1);
               int i = -e2 - q;
               int k = (i == 0 ? 1 : (int)(((long)i * 23219280L + 10000000L - 1L) / 10000000L)) - 121;
               int j = q - k;
               int actualShift = j - 93 - 21;
               if (actualShift < 0) {
                  throw new IllegalArgumentException("" + actualShift);
               }

               int[] ints = POW5_SPLIT[i];
               long mHigh = mv >>> 31;
               long mLow = mv & 2147483647L;
               long bits13 = mHigh * (long)ints[0];
               long bits03 = mLow * (long)ints[0];
               long bits12 = mHigh * (long)ints[1];
               long bits02 = mLow * (long)ints[1];
               long bits11 = mHigh * (long)ints[2];
               long bits01 = mLow * (long)ints[2];
               long bits10 = mHigh * (long)ints[3];
               long bits00 = mLow * (long)ints[3];
               dv = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
               mHigh = mp >>> 31;
               mLow = mp & 2147483647L;
               bits13 = mHigh * (long)ints[0];
               bits03 = mLow * (long)ints[0];
               bits12 = mHigh * (long)ints[1];
               bits02 = mLow * (long)ints[1];
               bits11 = mHigh * (long)ints[2];
               bits01 = mLow * (long)ints[2];
               bits10 = mHigh * (long)ints[3];
               bits00 = mLow * (long)ints[3];
               dp = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
               mHigh = mm >>> 31;
               mLow = mm & 2147483647L;
               bits13 = mHigh * (long)ints[0];
               bits03 = mLow * (long)ints[0];
               bits12 = mHigh * (long)ints[1];
               bits02 = mLow * (long)ints[1];
               bits11 = mHigh * (long)ints[2];
               bits01 = mLow * (long)ints[2];
               bits10 = mHigh * (long)ints[3];
               bits00 = mLow * (long)ints[3];
               dm = ((((bits00 >>> 31) + bits01 + bits10 >>> 31) + bits02 + bits11 >>> 31) + bits03 + bits12 >>> 21) + (bits13 << 10) >>> actualShift;
               e10 = q + e2;
               if (q <= 1) {
                  dvIsTrailingZeros = true;
                  if (even) {
                     dmIsTrailingZeros = mmShift == 1;
                  } else {
                     --dp;
                  }
               } else if (q < 63) {
                  dvIsTrailingZeros = (mv & (1L << q - 1) - 1L) == 0L;
               }
            }

            int vplength;
            if (dp >= 1000000000000000000L) {
               vplength = 19;
            } else if (dp >= 100000000000000000L) {
               vplength = 18;
            } else if (dp >= 10000000000000000L) {
               vplength = 17;
            } else if (dp >= 1000000000000000L) {
               vplength = 16;
            } else if (dp >= 100000000000000L) {
               vplength = 15;
            } else if (dp >= 10000000000000L) {
               vplength = 14;
            } else if (dp >= 1000000000000L) {
               vplength = 13;
            } else if (dp >= 100000000000L) {
               vplength = 12;
            } else if (dp >= 10000000000L) {
               vplength = 11;
            } else if (dp >= 1000000000L) {
               vplength = 10;
            } else if (dp >= 100000000L) {
               vplength = 9;
            } else if (dp >= 10000000L) {
               vplength = 8;
            } else if (dp >= 1000000L) {
               vplength = 7;
            } else if (dp >= 100000L) {
               vplength = 6;
            } else if (dp >= 10000L) {
               vplength = 5;
            } else if (dp >= 1000L) {
               vplength = 4;
            } else if (dp >= 100L) {
               vplength = 3;
            } else if (dp >= 10L) {
               vplength = 2;
            } else {
               vplength = 1;
            }

            int exp = e10 + vplength - 1;
            boolean scientificNotation = exp < -3 || exp >= 7;
            int removed = 0;
            int lastRemovedDigit = 0;
            long output;
            if (!dmIsTrailingZeros && !dvIsTrailingZeros) {
               while(dp / 10L > dm / 10L && (dp >= 100L || !scientificNotation)) {
                  lastRemovedDigit = (int)(dv % 10L);
                  dp /= 10L;
                  dv /= 10L;
                  dm /= 10L;
                  ++removed;
               }

               output = dv + (long)(dv != dm && lastRemovedDigit < 5 ? 0 : 1);
            } else {
               while(dp / 10L > dm / 10L && (dp >= 100L || !scientificNotation)) {
                  dmIsTrailingZeros &= dm % 10L == 0L;
                  dvIsTrailingZeros &= lastRemovedDigit == 0;
                  lastRemovedDigit = (int)(dv % 10L);
                  dp /= 10L;
                  dv /= 10L;
                  dm /= 10L;
                  ++removed;
               }

               if (dmIsTrailingZeros && even) {
                  while(dm % 10L == 0L && (dp >= 100L || !scientificNotation)) {
                     dvIsTrailingZeros &= lastRemovedDigit == 0;
                     lastRemovedDigit = (int)(dv % 10L);
                     dp /= 10L;
                     dv /= 10L;
                     dm /= 10L;
                     ++removed;
                  }
               }

               if (dvIsTrailingZeros && lastRemovedDigit == 5 && dv % 2L == 0L) {
                  lastRemovedDigit = 4;
               }

               output = dv + (long)((dv != dm || dmIsTrailingZeros && even) && lastRemovedDigit < 5 ? 0 : 1);
            }

            int olength = vplength - removed;
            if (sign) {
               index = off + 1;
               result[off] = '-';
            }

            if (scientificNotation) {
               for(int i = 0; i < olength - 1; ++i) {
                  int c = (int)(output % 10L);
                  output /= 10L;
                  result[index + olength - i] = (char)(48 + c);
               }

               result[index] = (char)((int)(48L + output % 10L));
               result[index + 1] = '.';
               index += olength + 1;
               if (olength == 1) {
                  result[index++] = '0';
               }

               result[index++] = 'E';
               if (exp < 0) {
                  result[index++] = '-';
                  exp = -exp;
               }

               if (exp >= 100) {
                  result[index++] = (char)(48 + exp / 100);
                  exp %= 100;
                  result[index++] = (char)(48 + exp / 10);
               } else if (exp >= 10) {
                  result[index++] = (char)(48 + exp / 10);
               }

               result[index++] = (char)(48 + exp % 10);
               return index - off;
            } else {
               if (exp < 0) {
                  result[index++] = '0';
                  result[index++] = '.';

                  for(int i = -1; i > exp; --i) {
                     result[index++] = '0';
                  }

                  int current = index;

                  for(int i = 0; i < olength; ++i) {
                     result[current + olength - i - 1] = (char)((int)(48L + output % 10L));
                     output /= 10L;
                     ++index;
                  }
               } else if (exp + 1 >= olength) {
                  for(int i = 0; i < olength; ++i) {
                     result[index + olength - i - 1] = (char)((int)(48L + output % 10L));
                     output /= 10L;
                  }

                  index += olength;

                  for(int i = olength; i < exp + 1; ++i) {
                     result[index++] = '0';
                  }

                  result[index++] = '.';
                  result[index++] = '0';
               } else {
                  int current = index + 1;

                  for(int i = 0; i < olength; ++i) {
                     if (olength - i - 1 == exp) {
                        result[current + olength - i - 1] = '.';
                        --current;
                     }

                     result[current + olength - i - 1] = (char)((int)(48L + output % 10L));
                     output /= 10L;
                  }

                  index += olength + 1;
               }

               return index - off;
            }
         }
      }
   }

   static {
      BigInteger mask = BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE);
      BigInteger invMask = BigInteger.ONE.shiftLeft(31).subtract(BigInteger.ONE);

      for(int i = 0; i < 326; ++i) {
         BigInteger pow = BigInteger.valueOf(5L).pow(i);
         int pow5len = pow.bitLength();
         int expectedPow5Bits = i == 0 ? 1 : (int)(((long)i * 23219280L + 10000000L - 1L) / 10000000L);
         if (expectedPow5Bits != pow5len) {
            throw new IllegalStateException(pow5len + " != " + expectedPow5Bits);
         }

         if (i < POW5_SPLIT.length) {
            for(int j = 0; j < 4; ++j) {
               POW5_SPLIT[i][j] = pow.shiftRight(pow5len - 121 + (3 - j) * 31).and(mask).intValue();
            }
         }

         if (i < POW5_INV_SPLIT.length) {
            int j = pow5len + 121;
            BigInteger inv = BigInteger.ONE.shiftLeft(j).divide(pow).add(BigInteger.ONE);

            for(int k = 0; k < 4; ++k) {
               if (k == 0) {
                  POW5_INV_SPLIT[i][k] = inv.shiftRight((3 - k) * 31).intValue();
               } else {
                  POW5_INV_SPLIT[i][k] = inv.shiftRight((3 - k) * 31).and(invMask).intValue();
               }
            }
         }
      }

   }
}
