package com.alibaba.fastjson.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class ServiceLoader {
   private static final String PREFIX = "META-INF/services/";
   private static final Set<String> loadedUrls = new HashSet();

   public static <T> Set<T> load(Class<T> clazz, ClassLoader classLoader) {
      if (classLoader == null) {
         return Collections.emptySet();
      } else {
         Set<T> services = new HashSet();
         String className = clazz.getName();
         String path = "META-INF/services/" + className;
         Set<String> serviceNames = new HashSet();

         try {
            Enumeration<URL> urls = classLoader.getResources(path);

            while(urls.hasMoreElements()) {
               URL url = (URL)urls.nextElement();
               if (!loadedUrls.contains(url.toString())) {
                  load(url, serviceNames);
                  loadedUrls.add(url.toString());
               }
            }
         } catch (Throwable var11) {
         }

         for(String serviceName : serviceNames) {
            try {
               Class<?> serviceClass = classLoader.loadClass(serviceName);
               T service = (T)serviceClass.newInstance();
               services.add(service);
            } catch (Exception var10) {
            }
         }

         return services;
      }
   }

   public static void load(URL url, Set<String> set) throws IOException {
      InputStream is = null;
      BufferedReader reader = null;

      try {
         is = url.openStream();
         reader = new BufferedReader(new InputStreamReader(is, "utf-8"));

         while(true) {
            String line = reader.readLine();
            if (line == null) {
               return;
            }

            int ci = line.indexOf(35);
            if (ci >= 0) {
               line = line.substring(0, ci);
            }

            line = line.trim();
            if (line.length() != 0) {
               set.add(line);
            }
         }
      } finally {
         IOUtils.close(reader);
         IOUtils.close(is);
      }
   }
}
