package com.alibaba.fastjson.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

/** @deprecated */
public class UTF8Decoder extends CharsetDecoder {
   private static final Charset charset = Charset.forName("UTF-8");

   public UTF8Decoder() {
      super(charset, 1.0F, 1.0F);
   }

   private static boolean isNotContinuation(int b) {
      return (b & 192) != 128;
   }

   private static boolean isMalformed2(int b1, int b2) {
      return (b1 & 30) == 0 || (b2 & 192) != 128;
   }

   private static boolean isMalformed3(int b1, int b2, int b3) {
      return b1 == -32 && (b2 & 224) == 128 || (b2 & 192) != 128 || (b3 & 192) != 128;
   }

   private static boolean isMalformed4(int b2, int b3, int b4) {
      return (b2 & 192) != 128 || (b3 & 192) != 128 || (b4 & 192) != 128;
   }

   private static CoderResult lookupN(ByteBuffer src, int n) {
      for(int i = 1; i < n; ++i) {
         if (isNotContinuation(src.get())) {
            return CoderResult.malformedForLength(i);
         }
      }

      return CoderResult.malformedForLength(n);
   }

   public static CoderResult malformedN(ByteBuffer src, int nb) {
      switch (nb) {
         case 1:
            int b1 = src.get();
            if (b1 >> 2 == -2) {
               if (src.remaining() < 4) {
                  return CoderResult.UNDERFLOW;
               }

               return lookupN(src, 5);
            } else {
               if (b1 >> 1 == -2) {
                  if (src.remaining() < 5) {
                     return CoderResult.UNDERFLOW;
                  }

                  return lookupN(src, 6);
               }

               return CoderResult.malformedForLength(1);
            }
         case 2:
            return CoderResult.malformedForLength(1);
         case 3:
            int b12 = src.get();
            int b22 = src.get();
            return CoderResult.malformedForLength((b12 != -32 || (b22 & 224) != 128) && !isNotContinuation(b22) ? 2 : 1);
         case 4:
            int b13 = src.get() & 255;
            int b23 = src.get() & 255;
            if (b13 <= 244 && (b13 != 240 || b23 >= 144 && b23 <= 191) && (b13 != 244 || (b23 & 240) == 128) && !isNotContinuation(b23)) {
               if (isNotContinuation(src.get())) {
                  return CoderResult.malformedForLength(2);
               }

               return CoderResult.malformedForLength(3);
            }

            return CoderResult.malformedForLength(1);
         default:
            throw new IllegalStateException();
      }
   }

   private static CoderResult malformed(ByteBuffer src, int sp, CharBuffer dst, int dp, int nb) {
      src.position(sp - src.arrayOffset());
      CoderResult cr = malformedN(src, nb);
      src.position(sp);
      dst.position(dp);
      return cr;
   }

   private static CoderResult xflow(Buffer src, int sp, int sl, Buffer dst, int dp, int nb) {
      src.position(sp);
      dst.position(dp);
      return nb != 0 && sl - sp >= nb ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
   }

   private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
      byte[] srcArray = src.array();
      int srcPosition = src.arrayOffset() + src.position();
      int srcLength = src.arrayOffset() + src.limit();
      char[] destArray = dst.array();
      int destPosition = dst.arrayOffset() + dst.position();
      int destLength = dst.arrayOffset() + dst.limit();

      for(int destLengthASCII = destPosition + Math.min(srcLength - srcPosition, destLength - destPosition); destPosition < destLengthASCII && srcArray[srcPosition] >= 0; destArray[destPosition++] = (char)srcArray[srcPosition++]) {
      }

      while(srcPosition < srcLength) {
         int b1 = srcArray[srcPosition];
         if (b1 < 0) {
            if (b1 >> 5 == -2) {
               if (srcLength - srcPosition < 2 || destPosition >= destLength) {
                  return xflow(src, srcPosition, srcLength, dst, destPosition, 2);
               }

               int b2 = srcArray[srcPosition + 1];
               if (isMalformed2(b1, b2)) {
                  return malformed(src, srcPosition, dst, destPosition, 2);
               }

               destArray[destPosition++] = (char)(b1 << 6 ^ b2 ^ 3968);
               srcPosition += 2;
            } else if (b1 >> 4 == -2) {
               if (srcLength - srcPosition < 3 || destPosition >= destLength) {
                  return xflow(src, srcPosition, srcLength, dst, destPosition, 3);
               }

               int b2 = srcArray[srcPosition + 1];
               int b3 = srcArray[srcPosition + 2];
               if (isMalformed3(b1, b2, b3)) {
                  return malformed(src, srcPosition, dst, destPosition, 3);
               }

               destArray[destPosition++] = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 8064);
               srcPosition += 3;
            } else {
               if (b1 >> 3 != -2) {
                  return malformed(src, srcPosition, dst, destPosition, 1);
               }

               if (srcLength - srcPosition >= 4 && destLength - destPosition >= 2) {
                  int b2 = srcArray[srcPosition + 1];
                  int b3 = srcArray[srcPosition + 2];
                  int b4 = srcArray[srcPosition + 3];
                  int uc = (b1 & 7) << 18 | (b2 & 63) << 12 | (b3 & 63) << 6 | b4 & 63;
                  if (!isMalformed4(b2, b3, b4) && uc >= 65536 && uc <= 1114111) {
                     destArray[destPosition++] = (char)('\ud800' | uc - 65536 >> 10 & 1023);
                     destArray[destPosition++] = (char)('\udc00' | uc - 65536 & 1023);
                     srcPosition += 4;
                     continue;
                  }

                  return malformed(src, srcPosition, dst, destPosition, 4);
               }

               return xflow(src, srcPosition, srcLength, dst, destPosition, 4);
            }
         } else {
            if (destPosition >= destLength) {
               return xflow(src, srcPosition, srcLength, dst, destPosition, 1);
            }

            destArray[destPosition++] = (char)b1;
            ++srcPosition;
         }
      }

      return xflow(src, srcPosition, srcLength, dst, destPosition, 0);
   }

   protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
      return this.decodeArrayLoop(src, dst);
   }
}
