package com.palacesun.engine.gateway;

import com.palacesun.engine.gateway.cache.CacheFromEncryptionGateway;
import com.palacesun.engine.gateway.cache.UserOriginalVO;
import com.palacesun.masking.appuser.AppUser;
import java.util.ArrayList;
import java.util.List;

public class GatewayContext {
   public static boolean isPluginEnabled() {
      if (CacheFromEncryptionGateway.appUserGlobalOriginalConfig == null) {
         return true;
      } else if (CacheFromEncryptionGateway.appUserGlobalOriginalConfig == null) {
         return false;
      } else {
         return CacheFromEncryptionGateway.appUserGlobalOriginalConfig == 1;
      }
   }

   public static boolean isCurrentUserCanSeeDecInfo() {
      if (CacheFromEncryptionGateway.gatewayUserGlobalOriginalConfig != null && CacheFromEncryptionGateway.gatewayUserGlobalOriginalConfig == 1) {
         String user = AppUser.loginUser();
         List<UserOriginalVO> users = copyPlatformUsers();
         return checkUserOriginal(user, users);
      } else if (CacheFromEncryptionGateway.appUserGlobalOriginalConfig != null && CacheFromEncryptionGateway.appUserGlobalOriginalConfig == 1) {
         String user = AppUser.loginUser();
         List<UserOriginalVO> users = copyUsers();
         if (users != null && users.size() > 0 && user != null && user.length() > 0) {
            for(UserOriginalVO x : users) {
               if (x.getUsername().equals(user)) {
                  return "1".equals(x.getIsOriginal());
               }
            }
         }

         return checkUserOriginal(user, users);
      } else {
         return false;
      }
   }

   private static boolean checkUserOriginal(String user, List<UserOriginalVO> users) {
      if (users != null && users.size() != 0 && user != null && user.length() != 0) {
         for(UserOriginalVO x : users) {
            if (x.getUsername() != null && x.getUsername().equals(user)) {
               return x.getIsOriginal().equals("1");
            }
         }

         return true;
      } else {
         return true;
      }
   }

   private static boolean checkUserMask(String user, List<UserOriginalVO> users) {
      if (users != null && users.size() != 0 && user != null && user.length() != 0) {
         for(UserOriginalVO x : users) {
            if (x.getUsername() != null && x.getUsername().equals(user)) {
               return x.getIsmask().equals("1");
            }
         }

         return true;
      } else {
         return true;
      }
   }

   public static boolean isCurrentUserNeedMask() {
      if (CacheFromEncryptionGateway.gatewayUserGlobalOriginalConfig != null && CacheFromEncryptionGateway.gatewayUserGlobalOriginalConfig == 1) {
         System.out.println("@@插件---gatewayUserGlobalOriginalConfig当前用户：" + AppUser.loginUser());
         String user = AppUser.loginUser();
         List<UserOriginalVO> users = copyPlatformUsers();
         return checkUserMask(user, users);
      } else if (CacheFromEncryptionGateway.appUserGlobalOriginalConfig != null && CacheFromEncryptionGateway.appUserGlobalOriginalConfig == 1) {
         System.out.println("@@插件---appUserGlobalOriginalConfig当前用户：" + AppUser.loginUser());
         String user = AppUser.loginUser();
         List<UserOriginalVO> users = copyUsers();
         if (users != null && users.size() > 0 && user != null && user.length() > 0) {
            for(UserOriginalVO x : users) {
               System.out.println("@@插件---当前用户：" + x.getUsername());
               if (x.getUsername().equals(user)) {
                  return "1".equals(x.getIsmask());
               }
            }
         }

         return checkUserMask(user, users);
      } else {
         return false;
      }
   }

   static List<UserOriginalVO> copyUsers() {
      while(true) {
         try {
            List<UserOriginalVO> apps = new ArrayList();
            if (CacheFromEncryptionGateway.appUserOriginalInfos != null) {
               apps.addAll(CacheFromEncryptionGateway.appUserOriginalInfos);
            }

            return apps;
         } catch (Exception var3) {
            try {
               Thread.sleep(10L);
            } catch (InterruptedException interruptedException) {
               interruptedException.printStackTrace();
            }
         }
      }
   }

   static List<UserOriginalVO> copyPlatformUsers() {
      while(true) {
         try {
            List<UserOriginalVO> platformUsers = new ArrayList();
            if (CacheFromEncryptionGateway.gatewayUserOriginalInfos != null) {
               platformUsers.addAll(CacheFromEncryptionGateway.gatewayUserOriginalInfos);
            }

            return platformUsers;
         } catch (Exception var3) {
            try {
               Thread.sleep(10L);
            } catch (InterruptedException interruptedException) {
               interruptedException.printStackTrace();
            }
         }
      }
   }
}
