package com.palacesun.engine.spy;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JNDIDriver implements Driver {
   public static Driver INSTANCE = new JNDIDriver();
   private static final String URL_PATTERN_REGEX = "^java:comp/env/.*$";
   private static final String URL_NOT_MATCH_PATTERN_REGEX = "^java:comp/env/masking:.*$";
   private static final Pattern URL_PATTERN = Pattern.compile("^java:comp/env/.*$", 2);
   private static final Pattern URL_NOT_MATCH_PATTERN = Pattern.compile("^java:comp/env/masking:.*$", 2);
   private static final String URL_MERN_REGEX_JBOSS = "^java:jboss/.*$";
   private static final String URL_NOT_MATCH_PATTERN_REGEX_JBOSS = "^java:jboss/masking/.*$";
   private static final Pattern URL_PATTERN_JBOSS = Pattern.compile("^java:jboss/.*$", 2);
   private static final Pattern URL_NOT_MATCH_PATTERN_JBOSS = Pattern.compile("^java:jboss/masking/.*$", 2);
   private static InitialContext CONTEXT = null;

   public Connection connect(String url, Properties info) throws SQLException {
      try {
         if (url.indexOf("java:jboss/") != -1) {
            url = url.replace("java:jboss/", "java:jboss/masking/");
         } else {
            url = url.replace("java:comp/env/", "java:comp/env/masking:");
         }

         DataSource ds = (DataSource)CONTEXT.lookup(url);
         Connection conn = ds.getConnection();
         return conn;
      } catch (NamingException e) {
         throw new SQLException(e);
      }
   }

   public boolean acceptsURL(String url) {
      if (url != null && url.length() != 0) {
         if (url.indexOf("java:jboss/") != -1) {
            return URL_PATTERN_JBOSS.matcher(url).matches() && !URL_NOT_MATCH_PATTERN_JBOSS.matcher(url).matches();
         } else {
            return URL_PATTERN.matcher(url).matches() && !URL_NOT_MATCH_PATTERN.matcher(url).matches();
         }
      } else {
         return false;
      }
   }

   public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
      return INSTANCE.getPropertyInfo(url, info);
   }

   public int getMajorVersion() {
      return 0;
   }

   public int getMinorVersion() {
      return 0;
   }

   public boolean jdbcCompliant() {
      return false;
   }

   public java.util.logging.Logger getParentLogger() throws java.sql.SQLFeatureNotSupportedException {
      return null;
   }

   static {
      try {
         CONTEXT = new InitialContext();
      } catch (NamingException e) {
         e.printStackTrace();
      }

   }
}
