package com.palacesun.engine.spy.appender;

import com.palacesun.engine.logging.Category;

public class BatchFileLogger extends FileLogger {
   public static final char BATCH_SEPARATOR = ';';
   private boolean endOfStatement = true;

   public void logException(Exception e) {
   }

   public void logSQL(int connectionId, String now, long elapsed, Category category, String prepared, String sql, String url) {
      if (this.endOfStatement) {
         this.getStream().println(';');
      }

      if (Category.STATEMENT.equals(category)) {
         String actual = null != sql && 0 != sql.length() ? sql : prepared;
         this.getStream().print(actual);
         this.endOfStatement = true;
      } else if (!Category.COMMIT.equals(category) && !Category.ROLLBACK.equals(category)) {
         this.getStream().println("-- " + category);
         this.endOfStatement = false;
      } else {
         this.getStream().print(category);
         this.endOfStatement = true;
      }

      this.getStream().flush();
   }

   public void logText(String text) {
   }
}
