package com.palacesun.engine.spy.option;

import com.palacesun.engine.spy.P6ModuleManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class SystemProperties implements P6OptionsSource {
   public static final String P6SPY_PREFIX = "p6spy.config.";

   public Map<String, String> getOptions() {
      Map<String, String> result = new HashMap();

      for(Map.Entry<Object, Object> entry : new HashSet<Map.Entry<Object, Object>>(((Properties)System.getProperties().clone()).entrySet())) {
         String key = entry.getKey().toString();
         if (key.startsWith("p6spy.config.")) {
            result.put(key.substring("p6spy.config.".length()), (String)entry.getValue());
         }
      }

      return result;
   }

   public void postInit(P6ModuleManager p6moduleManager) {
   }

   public void preDestroy(P6ModuleManager p6moduleManager) {
   }
}
