package com.palacesun.engine.wrapper;

import bean.Column;
import com.palacesun.engine.common.ResultSetInformation;
import com.palacesun.engine.common.StatementInformation;
import com.palacesun.engine.event.JdbcEventListener;
import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.engine.gateway.GatewayContext;
import com.palacesun.engine.test.DbCache;
import com.palacesun.engine.test.TestJdbcEventListener;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.palacesun.masking.appuser.AppUser;
import com.palacesun.masking.log.access.AccessContext;
import com.palacesun.masking.log.access.SqlBuffer;
import com.palacesun.masking.tools.EngineUtil;
import com.palacesun.masking.tools.InsertSqlVaulesUtil;
import com.palacesun.masking.tools.ruleload.RuleLoadUtil;
import com.palacesun.masking.vo.Columninfo;
import com.palacesun.masking.vo.ConnectionInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.SqlUtil;
import util.StringJoin;

public class StatementWrapper extends AbstractWrapper implements Statement {
   private static final String LINE_SEPARATOR = System.getProperty("line.separator");
   private final Statement delegate;
   protected final JdbcEventListener eventListener;
   private final StatementInformation statementInformation;
   protected SqlBuffer sqlBuffer;
   private static final String ENCRYPT_LIKE_OPEN = EncryptionGatewayManager.getParameterValue("encryption.like.open");
   private static final String ENCRYPT_SEPARATOR = EncryptionGatewayManager.getParameterValue("encryption.separator");
   public static Map<String, String> dbTypeMap = new HashMap();

   public static Statement wrap(Statement delegate, StatementInformation statementInformation, JdbcEventListener eventListener) {
      if (delegate == null) {
         return null;
      } else {
         StatementWrapper wrapper = new StatementWrapper(delegate, statementInformation, eventListener);
         return wrapper;
      }
   }

   protected StatementWrapper(Statement delegate, StatementInformation statementInformation, JdbcEventListener eventListener) {
      super(delegate);
      this.delegate = delegate;
      this.eventListener = eventListener;
      this.statementInformation = statementInformation;
      statementInformation.setStatement(delegate);
      if (statementInformation.context == null) {
         statementInformation.context = new AccessContext(statementInformation);
      }

      this.sqlBuffer = statementInformation.context.getBuffer();
   }

   public ResultSet getResultSet() throws SQLException {
      SQLException e = null;
      long start = System.nanoTime();

      ResultSet var4;
      try {
         var4 = ResultSetWrapper.wrap(this.delegate.getResultSet(), new ResultSetInformation(this.statementInformation), this.eventListener);
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterGetResultSet(this.statementInformation, System.nanoTime() - start, e);
      }

      return var4;
   }

   public ResultSet executeQuery(String sql) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
         try {
            this.statementInformation.setStatementQuery(sql);
            context.setStatementInfo(this.statementInformation);
            sql = this.encData(this.statementInformation);
         } catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
         }
      }

      this.statementInformation.setStatementQuery(sql);
      SQLException e = null;
      long start = System.nanoTime();

      ResultSet var6;
      try {
         this.eventListener.onBeforeExecuteQuery(this.statementInformation, sql);
         var6 = ResultSetWrapper.wrap(this.delegate.executeQuery(sql), new ResultSetInformation(this.statementInformation), this.eventListener);
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecuteQuery(this.statementInformation, System.nanoTime() - start, sql, e);
      }

      return var6;
   }

   public String encData(StatementInformation statementInformation) throws Exception {
      String returnSql = "";
      SqlUtil sqlUtil = new SqlUtil();
      String sqlUser = "";
      String dbType = "";
      String urlDbType = statementInformation.getConnectionInformation().getUrl();
      String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
      dbType = ConnectionWrapper.getDbType(driverName, urlDbType, dbType);
      new ArrayList();

      try {
         Connection connection = statementInformation.getConnectionInformation().getConnection();
         String urlTemp = connection.getMetaData().getURL();
         String ip = (String)TestJdbcEventListener.getIpAndPort(urlTemp).get("ip");
         String port = (String)TestJdbcEventListener.getIpAndPort(urlTemp).get("port");
         String schema = "";
         if ("oracle".equals(dbType)) {
            schema = connection.getMetaData().getUserName();
         } else if (!"postgresql".equals(dbType) && !"greenplum".equals(dbType) && !"gauss".equals(dbType)) {
            if ("sql server".equals(dbType)) {
               String url = connection.getMetaData().getURL();
               if (url.indexOf("applicationName") > 0) {
                  schema = url.substring(url.indexOf("applicationName") + "applicationName".length() + 1);
                  if (schema.indexOf(";") != -1) {
                     schema = schema.substring(0, schema.indexOf(";"));
                  }
               } else {
                  schema = "dbo";
               }
            } else if ("dm".equals(dbType)) {
               String url = connection.getMetaData().getURL();
               if (url.toLowerCase().contains("schema=")) {
                  schema = url.substring(url.toLowerCase().indexOf("schema=") + 7);
               } else {
                  int from = url.indexOf("://");
                  int end = url.indexOf("?");
                  String address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                  int idx = address.lastIndexOf("/");
                  schema = address.substring(idx + 1);
               }
            } else if ("db2".equals(dbType)) {
               Statement stmt = connection.createStatement();
               ResultSet rs = stmt.executeQuery("SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1");
               if (rs.next()) {
                  schema = rs.getString(1).trim();
               } else {
                  schema = connection.getMetaData().getUserName();
               }

               rs.close();
               stmt.close();
            } else if ("kingbase".equals(dbType)) {
               String url = connection.getMetaData().getURL();
               if (url.indexOf("searchpath") > 0) {
                  schema = url.substring(url.indexOf("searchpath") + 11);
                  if (schema.indexOf(",") != -1) {
                     schema = schema.substring(0, schema.indexOf(","));
                  }
               } else if (url.indexOf("currentSchema") > 0) {
                  schema = url.substring(url.indexOf("currentSchema") + 14);
                  if (schema.indexOf(",") != -1) {
                     schema = schema.substring(0, schema.indexOf(","));
                  }
               } else {
                  schema = "public";
               }
            } else if ("mysql".equals(dbType)) {
               String url = connection.getMetaData().getURL();
               int from = url.indexOf("://");
               int end = url.indexOf("?");
               String address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
               int idx = address.lastIndexOf("/");
               schema = address.substring(idx + 1);
            } else if ("mariadb".equals(dbType)) {
               String url = connection.getMetaData().getURL();
               int from = url.indexOf("://");
               int end = url.indexOf("?");
               String address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
               int idx = address.lastIndexOf("/");
               schema = address.substring(idx + 1);
            } else if ("hive".equals(dbType)) {
               String url = connection.getMetaData().getURL();
               int from = url.indexOf("://");
               int end = url.indexOf("?");
               String address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
               int idx = address.lastIndexOf("/");
               schema = address.substring(idx + 1);
               if (schema.indexOf(";") > 0) {
                  schema = schema.substring(0, schema.indexOf(";"));
               }
            } else {
               schema = connection.getCatalog();
            }
         } else {
            String url = connection.getMetaData().getURL();
            if (url.indexOf("searchpath") > 0) {
               schema = url.substring(url.indexOf("searchpath") + 11);
            } else if (url.indexOf("currentSchema") > 0) {
               schema = url.substring(url.indexOf("currentSchema") + 14);
            } else if (url.toLowerCase().indexOf("schema=") > 0) {
               schema = url.substring(url.indexOf("schema=") + 7);
            } else {
               schema = "public";
            }
         }

         String sqlTemp = statementInformation.getSql();
         int n = sqlTemp.indexOf("-- appUsername=");
         sqlUser = sqlTemp.substring(sqlTemp.indexOf("-- appUsername="));
         String sqlAll = sqlTemp.substring(0, n).trim();
         String[] split = sqlAll.split(";\r\n");

         for(int i = 0; i < split.length; ++i) {
            String sql = split[i];
            new ArrayList();
            new ArrayList();
            Map<String, String> whereStringList = new HashMap();
            List<Map<String, Object>> stringObjectMapList = (List)ConnectionWrapper.sqlParseMap.get(sqlAll);
            if (stringObjectMapList == null || stringObjectMapList.isEmpty()) {
               stringObjectMapList = statementInformation.sqlParse;
            }

            if (stringObjectMapList == null || stringObjectMapList.isEmpty()) {
               stringObjectMapList = this.sortColumns(statementInformation, sql, dbType, schema);
            }

            Map<String, Object> stringObjectMap = (Map)stringObjectMapList.get(i);
            ArrayList<Column> columnList = (ArrayList)stringObjectMap.get("columnList");
            if (columnList == null || columnList.isEmpty()) {
               String sqlTmp = statementInformation.getSql().toLowerCase().trim();
               if (!sqlTmp.startsWith("delete")) {
                  RuleLoadUtil.writeLog("@@插件@@---statementWrapper--->解析出的columnList为空-数据库类型：" + dbType + ":schema:" + schema);
                  return statementInformation.getSql();
               }
            }

            List<Map> whereList = (List)stringObjectMap.get("whereList");
            Boolean encFlag = false;
            Set encryFieldSet = new HashSet();
            if (whereList != null && !whereList.isEmpty()) {
               encFlag = this.encryption(ip, port, schema, false, whereList, encryFieldSet);
               if (encFlag) {
                  sql = this.encryptionWhere(statementInformation, sqlUtil, sql, dbType, schema, whereList, whereStringList);
               }
            }

            returnSql = returnSql + sql + ";";
         }

         if (returnSql.endsWith(";")) {
            returnSql = returnSql.substring(0, returnSql.length() - 1);
         }
      } catch (Exception e1) {
         e1.printStackTrace();
         throw e1;
      }

      returnSql = returnSql.concat(" ").concat(sqlUser);
      return returnSql;
   }

   private Boolean encryption(String ip, String port, String schema, Boolean encFlag, List<Map> whereList, Set encryFieldSet) throws Exception {
      for(Map<String, Object> whereMap : whereList) {
         String key = (String)whereMap.get("column");
         String columnName = key.contains(".") ? key.split("\\.")[2].replace("\"", "") : key.replace("\"", "");
         String tableName = key.contains(".") ? key.split("\\.")[1] : "";
         schema = key.contains(".") ? key.split("\\.")[0] : schema;
         if (String.valueOf(whereMap.get("columnValue")).trim().equals("?")) {
            break;
         }

         String mathKey = (ip + "_" + port + "_" + schema + "_" + tableName + "_" + columnName).toLowerCase().replace("`", "").replace("\"", "");
         if (EngineUtil.encryptionMap.isEmpty()) {
            EngineUtil.keyCacheFromFile();
         }

         boolean ismaksing = EngineUtil.encryptionMap.containsKey(mathKey);
         if (ismaksing) {
            Boolean flag = false;

            try {
               Columninfo map = (Columninfo)EngineUtil.encryptionMap.get(mathKey);
               Object value = whereMap.get("columnValue");
               if (value != null) {
                  String type = (String)whereMap.get("type");
                  if (type.toUpperCase().equals("LIKE")) {
                     String likeValue = ((String)value).trim();
                     boolean beforeLike = false;
                     boolean afterLike = false;
                     if (!likeValue.equals("%%")) {
                        if (likeValue.startsWith("%")) {
                           likeValue = likeValue.substring(1);
                           beforeLike = true;
                        }

                        if (likeValue.endsWith("%")) {
                           likeValue = likeValue.substring(0, likeValue.length() - 1);
                           afterLike = true;
                        }

                        value = EngineUtil.exeEngine(map, (ConnectionInfo)null, false, likeValue, true);
                        if (afterLike) {
                           value = value.toString().replace(ENCRYPT_SEPARATOR, "");
                        }

                        if (ENCRYPT_LIKE_OPEN.equals(map.getIsLike())) {
                           if (beforeLike) {
                              value = "%" + value;
                           }

                           if (afterLike) {
                              value = value + "%";
                           }
                        }
                     }
                  } else {
                     value = EngineUtil.exeEngine(map, (ConnectionInfo)null, false, value, true);
                  }
               }

               whereMap.put("columnValue", value);
               encFlag = true;
               encryFieldSet.add(mathKey);
            } catch (Exception e1) {
               e1.printStackTrace();
               throw e1;
            } finally {
               ;
            }
         }
      }

      return encFlag;
   }

   private String encryptionWhere(StatementInformation statementInformation, SqlUtil sqlUtil, String sql, String dbType, String schema, List<Map> whereList, Map<String, String> whereStringList) throws Exception {
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", dbType);
      params.put("schema", schema);
      params.put("encryption", "1");
      params.put("url", statementInformation.getConnectionInformation().getConnection().getMetaData().getURL());

      for(Map entry : whereList) {
         if (entry.get("columnValue") instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)entry.get("columnValue");
            ArrayList valueList = new ArrayList();

            for(int v = 0; v < arrayList.size(); ++v) {
               if (arrayList.get(v) instanceof SQLCharExpr) {
                  valueList.add(((SQLCharExpr)arrayList.get(v)).getText());
               }
            }

            whereStringList.put((String)entry.get("column"), StringJoin.join(valueList, ","));
         } else {
            whereStringList.put((String)entry.get("column"), (String)entry.get("columnValue"));
         }
      }

      sql = sqlUtil.pareSqlReplaceValue2(params, whereList);
      return sql;
   }

   private List<Object> getInsertSqlValueList(String sql, List<Object> valueList) {
      String lowerSql = sql.toLowerCase();
      String tempsql = "";
      if (lowerSql.contains("values")) {
         tempsql = sql.substring(lowerSql.indexOf("values") + 6);
         tempsql = tempsql.replaceFirst("\\(", "");
         tempsql = tempsql.replaceFirst("[\\\\)]+$", "");
         if (tempsql.trim().endsWith(";")) {
            tempsql = tempsql.trim().substring(0, tempsql.trim().length() - 1);
         }

         valueList = InsertSqlVaulesUtil.getTableColumnValueByMatchingSingleQuotes(tempsql.split(","));
      }

      return valueList;
   }

   private List<Map<String, Object>> sortColumns(StatementInformation statementInformation, String sql, String dbType, String schema) throws SQLException {
      Map<String, String> params = new HashMap();
      params.put("sql", sql);
      params.put("dbType", dbType);
      params.put("schema", schema);
      params.put("encryption", "1");
      String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
      params.put("url", url);
      SqlUtil sqlUtil = new SqlUtil();
      List<Map<String, Object>> maps = sqlUtil.parseSqlStructureEnc(params);
      if (maps != null && !maps.isEmpty()) {
         Map<String, Object> stringObjectMap = (Map)maps.get(0);
         if (!stringObjectMap.isEmpty()) {
            String trim = sql.toLowerCase().trim();
            if ((trim.startsWith("insert") || trim.startsWith("update")) && trim.contains("?")) {
               ConnectionWrapper.sqlParseMap.put(sql, maps);
            } else if (trim.startsWith("select")) {
               ConnectionWrapper.sqlParseMap.put(sql, maps);
            }

            statementInformation.sqlParse = maps;
         }
      }

      return maps;
   }

   private String getDbType(StatementInformation statementInformation, String dbType) throws Exception {
      try {
         dbType = "mysql";
         String hiveurl = statementInformation.getConnectionInformation().getUrl();
         if (hiveurl.toLowerCase().contains("hive")) {
            return "hive";
         } else {
            String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
            if (driverName.toLowerCase().contains("mysql")) {
               dbType = "mysql";
            } else if (driverName.toLowerCase().contains("oracle")) {
               dbType = "oracle";
            } else if (driverName.toLowerCase().contains("postgresql")) {
               String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
               if (url.contains("gauss")) {
                  dbType = "gauss";
                  return dbType;
               }

               if (url.contains("greenplum")) {
                  dbType = "greenplum";
                  return dbType;
               }

               dbType = "postgresql";
            } else if (driverName.toLowerCase().contains("hive")) {
               dbType = "hive";
            } else if (driverName.toLowerCase().contains("dm")) {
               dbType = "dm";
            } else if (driverName.toLowerCase().contains("ibm")) {
               dbType = "db2";
            } else if (driverName.toLowerCase().contains("sql server")) {
               dbType = "sql server";
            } else if (driverName.toLowerCase().contains("kingbase")) {
               dbType = "kingbase";
            } else if (driverName.toLowerCase().contains("vastbase")) {
               dbType = "postgresql";
            }

            return dbType;
         }
      } catch (Exception e) {
         e.printStackTrace();
         throw e;
      }
   }

   public int[] executeBatch() throws SQLException {
      SQLException e = null;
      long start = System.nanoTime();
      int[] updateCounts = null;

      int[] var5;
      try {
         this.eventListener.onBeforeExecuteBatch(this.statementInformation);
         updateCounts = this.delegate.executeBatch();
         var5 = updateCounts;
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecuteBatch(this.statementInformation, System.nanoTime() - start, updateCounts, e);
      }

      return var5;
   }

   public boolean execute(String sql) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      this.statementInformation.setStatementQuery(sql);
      SQLException e = null;
      long start = System.nanoTime();

      boolean var6;
      try {
         this.eventListener.onBeforeExecute(this.statementInformation, sql);
         var6 = this.delegate.execute(sql);
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
      }

      return var6;
   }

   public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      SQLException e = null;
      long start = System.nanoTime();

      boolean var7;
      try {
         this.eventListener.onBeforeExecute(this.statementInformation, sql);
         var7 = this.delegate.execute(sql, autoGeneratedKeys);
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
      }

      return var7;
   }

   public boolean execute(String sql, int[] columnIndexes) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      this.statementInformation.setStatementQuery(sql);
      SQLException e = null;
      long start = System.nanoTime();

      boolean var7;
      try {
         this.eventListener.onBeforeExecute(this.statementInformation, sql);
         var7 = this.delegate.execute(sql, columnIndexes);
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
      }

      return var7;
   }

   public boolean execute(String sql, String[] columnNames) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      SQLException e = null;
      long start = System.nanoTime();

      boolean var7;
      try {
         this.eventListener.onBeforeExecute(this.statementInformation, sql);
         var7 = this.delegate.execute(sql, columnNames);
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
      }

      return var7;
   }

   public int executeUpdate(String sql) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      SQLException e = null;
      long start = System.nanoTime();
      int rowCount = 0;

      int var7;
      try {
         this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
         rowCount = this.delegate.executeUpdate(sql);
         var7 = rowCount;
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
      }

      return var7;
   }

   public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      SQLException e = null;
      long start = System.nanoTime();
      int rowCount = 0;

      int var8;
      try {
         this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
         rowCount = this.delegate.executeUpdate(sql, autoGeneratedKeys);
         var8 = rowCount;
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
      }

      return var8;
   }

   public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      SQLException e = null;
      long start = System.nanoTime();
      int rowCount = 0;

      int var8;
      try {
         this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
         rowCount = this.delegate.executeUpdate(sql, columnIndexes);
         var8 = rowCount;
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
      }

      return var8;
   }

   public int executeUpdate(String sql, String[] columnNames) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      SQLException e = null;
      long start = System.nanoTime();
      int rowCount = 0;

      int var8;
      try {
         this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
         rowCount = this.delegate.executeUpdate(sql, columnNames);
         var8 = rowCount;
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
      }

      return var8;
   }

   public void addBatch(String sql) throws SQLException {
      sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
      AccessContext context = new AccessContext();
      this.statementInformation.context = context;
      this.statementInformation.setStatementQuery(sql);
      context.setStatementInfo(this.statementInformation);

      try {
         this.statementInformation.setStatementQuery(sql);
         if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            sql = this.encData(this.statementInformation);
         }
      } catch (Exception exception) {
         exception.printStackTrace();
         throw new SQLException(exception);
      }

      if (this.statementInformation.getStatementQuery() == null) {
         this.statementInformation.setStatementQuery(sql);
      } else {
         this.statementInformation.setStatementQuery(sql + LINE_SEPARATOR + this.statementInformation.getStatementQuery());
      }

      SQLException e = null;
      long start = System.nanoTime();

      try {
         this.eventListener.onBeforeAddBatch(this.statementInformation, sql);
         this.delegate.addBatch(sql);
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterAddBatch(this.statementInformation, System.nanoTime() - start, sql, e);
      }

   }

   public void close() throws SQLException {
      SQLException e = null;

      try {
         this.delegate.close();
      } catch (SQLException sqle) {
         e = sqle;
         throw sqle;
      } finally {
         this.eventListener.onAfterStatementClose(this.statementInformation, e);
      }

   }

   public int getMaxFieldSize() throws SQLException {
      return this.delegate.getMaxFieldSize();
   }

   public void setMaxFieldSize(int max) throws SQLException {
      this.delegate.setMaxFieldSize(max);
   }

   public int getMaxRows() throws SQLException {
      return this.delegate.getMaxRows();
   }

   public void setMaxRows(int max) throws SQLException {
      this.delegate.setMaxRows(max);
   }

   public void setEscapeProcessing(boolean enable) throws SQLException {
      this.delegate.setEscapeProcessing(enable);
   }

   public int getQueryTimeout() throws SQLException {
      return this.delegate.getQueryTimeout();
   }

   public void setQueryTimeout(int seconds) throws SQLException {
      this.delegate.setQueryTimeout(seconds);
   }

   public void cancel() throws SQLException {
      this.delegate.cancel();
   }

   public SQLWarning getWarnings() throws SQLException {
      return this.delegate.getWarnings();
   }

   public void clearWarnings() throws SQLException {
      this.delegate.clearWarnings();
   }

   public void setCursorName(String name) throws SQLException {
      this.delegate.setCursorName(name);
   }

   public int getUpdateCount() throws SQLException {
      return this.delegate.getUpdateCount();
   }

   public boolean getMoreResults() throws SQLException {
      return this.delegate.getMoreResults();
   }

   public void setFetchDirection(int direction) throws SQLException {
      this.delegate.setFetchDirection(direction);
   }

   public int getFetchDirection() throws SQLException {
      return this.delegate.getFetchDirection();
   }

   public void setFetchSize(int rows) throws SQLException {
      this.delegate.setFetchSize(rows);
   }

   public int getFetchSize() throws SQLException {
      return this.delegate.getFetchSize();
   }

   public int getResultSetConcurrency() throws SQLException {
      return this.delegate.getResultSetConcurrency();
   }

   public int getResultSetType() throws SQLException {
      return this.delegate.getResultSetType();
   }

   public void clearBatch() throws SQLException {
      this.delegate.clearBatch();
   }

   public Connection getConnection() throws SQLException {
      return this.delegate.getConnection();
   }

   public boolean getMoreResults(int current) throws SQLException {
      return this.delegate.getMoreResults(current);
   }

   public ResultSet getGeneratedKeys() throws SQLException {
      return this.delegate.getGeneratedKeys();
   }

   public int getResultSetHoldability() throws SQLException {
      return this.delegate.getResultSetHoldability();
   }

   public boolean isClosed() throws SQLException {
      return this.delegate.isClosed();
   }

   public void setPoolable(boolean poolable) throws SQLException {
      this.delegate.setPoolable(poolable);
   }

   public boolean isPoolable() throws SQLException {
      return this.delegate.isPoolable();
   }

   public void closeOnCompletion() throws SQLException {
   }

   public boolean isCloseOnCompletion() throws SQLException {
      return true;
   }

   public static void main(String[] args) {
      String str = "123(select)";
      System.out.println(str.substring(3, 4));
   }
}
