package com.palacesun.masking.tools;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import java.sql.SQLSyntaxErrorException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseWhereKeyValue {
   public static SQLUpdateStatement aliParseUpdate(String dbType, String sql) throws SQLSyntaxErrorException {
      List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
      if (stmtList.size() > 1) {
         throw new SQLSyntaxErrorException("Multi is not supported,use single instead");
      } else {
         SQLUpdateStatement stmt = (SQLUpdateStatement)stmtList.get(0);
         return stmt;
      }
   }

   public static void main(String[] args) {
      String sql = "user_id='22'";
   }

   public static String findJosnValue(String key, String josn) {
      String regex = "\\S+" + key + "\": (\"(.*?)\"|(\\d*))";
      Matcher matcher = Pattern.compile(regex).matcher(josn);
      String value = null;
      if (matcher.find()) {
         value = matcher.group().split("\\:")[1].replace("\"", "").trim();
      }

      return value;
   }
}
