package com.palacesun.masking.tools;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.masking.adapter.StringUtils;
import com.palacesun.masking.vo.Columninfo;
import java.lang.reflect.Method;
import util.sqlparse.visitor.common.Objects;

public class ReflectUtil {
   private static final String REMOTE = "1";
   static String IS_REMOTE = EncryptionGatewayManager.getParameterValue("encryption.remote");
   private static String ENCRYPT_LABEL = EncryptionGatewayManager.getParameterValue("encryption.label");
   private static String ENCRYPT_LIKE_SPLIT = EncryptionGatewayManager.getParameterValue("encryption.like.split");
   private static boolean IS_CCORESDF = Boolean.valueOf(EncryptionGatewayManager.getParameterValue("ccoresdf"));
   private static String MODE = EncryptionGatewayManager.getParameterValue("mode");
   private static String ENCRYPT_SEPARATOR = EncryptionGatewayManager.getParameterValue("encryption.separator");

   public static void main(String[] args) throws Exception {
      System.out.println(Boolean.parseBoolean("0"));
   }

   public static String engine(String encType, String value, String key, String isLike, String keepfirst, String encdigit, String twoindex, Boolean decryptEcb, Columninfo info) throws Exception {
      String[] params = new String[]{encType};
      if ("1".equals(IS_REMOTE)) {
         String mode = null;
         if (IS_CCORESDF) {
            mode = MODE;
         }

         return !decryptEcb ? RemoteUtil.decryptEcb(key, value, isLike, keepfirst, encdigit, twoindex, encType, info, mode) : RemoteUtil.encryptEcb(key, value, isLike, keepfirst, encdigit, twoindex, encType, info, mode);
      } else {
         String ret = null;
         String className = "com.ghgc.masking.tools.Sm4Util";
         boolean sm4Util = false;
         if (encType != null && encType.length() > 0) {
            if (!"SM4".equals(encType) && !"SM4_ECB".equals(encType) && !"SM4_GCM".equals(encType) && !"SM4_CBC".equals(encType) && !"SM4_OFB".equals(encType) && !"SM4_CFB".equals(encType) && !"SM4_CCM".equals(encType)) {
               if ("SM4_FPE".equals(encType)) {
                  className = "com.ghgc.masking.tools.Sm4FPEUtil";
               } else if (!"AES".equals(encType) && !"AES128".equals(encType) && !"AES256".equals(encType) && !"AES192".equals(encType)) {
                  if ("DES".equals(encType)) {
                     className = "com.ghgc.masking.tools.DESUtil";
                  } else if ("SM4_FPE_IDENTITYNO".equals(encType)) {
                     className = "com.ghgc.masking.tools.sm4fpe.SM4FPEIdentityUtil";
                  } else if ("SM4_FPE_PHONE".equals(encType)) {
                     className = "com.ghgc.masking.tools.sm4fpe.SM4FPECellPhoneUtil";
                  } else if ("SM4_FPE_EMAIL".equals(encType)) {
                     className = "com.ghgc.masking.tools.sm4fpe.SM4FPEEmailUtil";
                  } else if ("SM4_FPE_NAME".equals(encType)) {
                     className = "com.ghgc.masking.tools.sm4fpe.SM4FPENameUtil";
                  } else if ("SM4_FPE_COMPANY_NAME".equals(encType)) {
                     className = "com.ghgc.masking.tools.sm4fpe.SM4FPECompanyUtil";
                  } else if ("SM4_FPE_ADDRESS".equals(encType)) {
                     className = "com.ghgc.masking.tools.sm4fpe.SM4FPEAddressUtil";
                  } else if ("3DES".equals(encType)) {
                     className = "com.ghgc.masking.tools.DES3Util";
                  }
               } else {
                  className = "com.ghgc.masking.tools.AESUtil";
               }
            } else {
               className = "com.ghgc.masking.tools.Sm4Util";
               sm4Util = true;
            }
         }

         String methodName = decryptEcb ? "encryptEcb" : "decryptEcb";
         Object obj = null;
         Method m = null;
         if (!sm4Util) {
            Class clz = Class.forName(className);
            obj = clz.newInstance();
            m = obj.getClass().getDeclaredMethod(methodName, String.class, String.class, String.class, String.class, String.class, String.class, String[].class);
         }

         value = value.trim();
         if (value.startsWith("'") && "encryptEcb".equals(methodName)) {
            value = value.substring(1, value.length());
         }

         if (value.trim().endsWith("'") && "encryptEcb".equals(methodName)) {
            value = value.substring(0, value.length() - 1);
         }

         if (decryptEcb) {
            if (value != null && value.length() != 0) {
               if (value.indexOf(ENCRYPT_LABEL) != -1) {
                  return value;
               } else {
                  String encrypt;
                  if (!sm4Util) {
                     encrypt = (String)m.invoke(obj, key, value, isLike, keepfirst, encdigit, twoindex, params);
                  } else {
                     encrypt = Sm4Util.encryptEcb(key, value, isLike, keepfirst, encdigit, twoindex, params);
                  }

                  if (Objects.equals(isLike, "0")) {
                     if (StringUtils.isBlank(encdigit)) {
                        return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                     } else if (Objects.equals(keepfirst, "0")) {
                        if (StringUtils.isBlank(encdigit)) {
                           return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                        } else if (Integer.parseInt(encdigit) < encrypt.length()) {
                           String prefix = encrypt.substring(0, Integer.parseInt(encdigit));
                           String enc = encrypt.substring(Integer.parseInt(encdigit));
                           return prefix + ENCRYPT_LABEL + enc + ENCRYPT_SEPARATOR;
                        } else {
                           return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                        }
                     } else if (Objects.equals(keepfirst, "1")) {
                        if (StringUtils.isBlank(encdigit)) {
                           return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                        } else if (Integer.parseInt(encdigit) < encrypt.length()) {
                           String prefix = encrypt.substring(encrypt.length() - Integer.parseInt(encdigit));
                           String enc = encrypt.substring(0, encrypt.length() - Integer.parseInt(encdigit));
                           return ENCRYPT_LABEL + enc + ENCRYPT_SEPARATOR + prefix;
                        } else {
                           return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                        }
                     } else if (Objects.equals(keepfirst, "2")) {
                        if (Integer.parseInt(encdigit) >= encrypt.length() && Integer.parseInt(twoindex) >= encrypt.length() && Integer.parseInt(encdigit) + Integer.parseInt(twoindex) >= encrypt.length()) {
                           return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                        } else {
                           String prefix = encrypt.substring(0, Integer.parseInt(encdigit));
                           String enc = encrypt.substring(Integer.parseInt(encdigit), encrypt.length() - Integer.parseInt(twoindex));
                           String suffix = encrypt.substring(encrypt.length() - Integer.parseInt(twoindex));
                           return prefix + ENCRYPT_LABEL + enc + ENCRYPT_SEPARATOR + suffix;
                        }
                     } else {
                        return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                     }
                  } else if (StringUtils.isBlank(encdigit)) {
                     return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                  } else if (Objects.equals(keepfirst, "0")) {
                     if (StringUtils.isBlank(encdigit)) {
                        return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                     } else if (Integer.parseInt(encdigit) < encrypt.length()) {
                        String prefix = encrypt.substring(0, Integer.parseInt(encdigit));
                        String enc = encrypt.substring(Integer.parseInt(encdigit));
                        return prefix + ENCRYPT_LABEL + enc + ENCRYPT_SEPARATOR;
                     } else {
                        return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                     }
                  } else if (Objects.equals(keepfirst, "1")) {
                     if (StringUtils.isBlank(encdigit)) {
                        return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                     } else if (Integer.parseInt(encdigit) < encrypt.length()) {
                        String prefix = encrypt.substring(encrypt.length() - Integer.parseInt(encdigit));
                        String enc = encrypt.substring(0, encrypt.length() - Integer.parseInt(encdigit));
                        return ENCRYPT_LABEL + enc + ENCRYPT_SEPARATOR + prefix;
                     } else {
                        return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                     }
                  } else if (Objects.equals(keepfirst, "2")) {
                     if (Integer.parseInt(encdigit) >= encrypt.length() && Integer.parseInt(twoindex) >= encrypt.length() && Integer.parseInt(encdigit) + Integer.parseInt(twoindex) >= encrypt.length()) {
                        return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                     } else {
                        String prefix = encrypt.substring(0, Integer.parseInt(encdigit));
                        String enc = encrypt.substring(Integer.parseInt(encdigit), encrypt.length() - Integer.parseInt(twoindex));
                        String suffix = encrypt.substring(encrypt.length() - Integer.parseInt(twoindex));
                        return prefix + ENCRYPT_LABEL + enc + ENCRYPT_SEPARATOR + suffix;
                     }
                  } else {
                     return ENCRYPT_LABEL + encrypt + ENCRYPT_SEPARATOR;
                  }
               }
            } else {
               return value;
            }
         } else {
            if (value.indexOf(ENCRYPT_LABEL) == -1) {
               ret = value;
            } else {
               value = value.startsWith(ENCRYPT_LABEL) ? value.substring(ENCRYPT_LABEL.length()) : value;
               if (sm4Util) {
                  ret = Sm4Util.decryptEcb(key, value, isLike, keepfirst, encdigit, twoindex, params);
               } else {
                  ret = (String)m.invoke(obj, key, value, isLike, keepfirst, encdigit, twoindex, params);
               }
            }

            return ret;
         }
      }
   }
}
