package org.apache.commons.jexl3;

public class JexlInfo {
   private final int line;
   private final int column;
   private final String name;

   public Detail getDetail() {
      return null;
   }

   public JexlInfo(String source, int l, int c) {
      this.name = source;
      this.line = l;
      this.column = c;
   }

   public JexlInfo at(int l, int c) {
      return new JexlInfo(this.name, l, c);
   }

   protected JexlInfo(JexlInfo copy) {
      this.name = copy.getName();
      this.line = copy.getLine();
      this.column = copy.getColumn();
   }

   public String toString() {
      StringBuilder sb = new StringBuilder(this.name != null ? this.name : "");
      if (this.line > 0) {
         sb.append("@");
         sb.append(this.line);
         if (this.column > 0) {
            sb.append(":");
            sb.append(this.column);
         }
      }

      Detail dbg = this.getDetail();
      if (dbg != null) {
         sb.append("![");
         sb.append(dbg.start());
         sb.append(",");
         sb.append(dbg.end());
         sb.append("]: '");
         sb.append(dbg.toString());
         sb.append("'");
      }

      return sb.toString();
   }

   public final String getName() {
      return this.name;
   }

   public final int getLine() {
      return this.line;
   }

   public final int getColumn() {
      return this.column;
   }

   public interface Detail {
      int start();

      int end();

      String toString();
   }
}
