package org.apache.commons.jexl3;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public interface JexlScript {
   String getSourceText();

   String getParsedText();

   String getParsedText(int var1);

   Object execute(JexlContext var1);

   Object execute(JexlContext var1, Object... var2);

   String[] getParameters();

   String[] getLocalVariables();

   Set<List<String>> getVariables();

   Map<String, Object> getPragmas();

   Callable<Object> callable(JexlContext var1);

   Callable<Object> callable(JexlContext var1, Object... var2);

   JexlScript curry(Object... var1);
}
