package org.apache.commons.jexl3;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JxltEngine {
   public Expression createExpression(String expression) {
      return this.createExpression((JexlInfo)null, expression);
   }

   public abstract Expression createExpression(JexlInfo var1, String var2);

   public abstract Template createTemplate(JexlInfo var1, String var2, Reader var3, String... var4);

   public Template createTemplate(JexlInfo info, String source, String... parms) {
      return this.createTemplate(info, "$$", new StringReader(source), parms);
   }

   public Template createTemplate(JexlInfo info, String source) {
      return this.createTemplate(info, "$$", new StringReader(source), (String[])null);
   }

   public Template createTemplate(String prefix, Reader source, String... parms) {
      return this.createTemplate((JexlInfo)null, prefix, source, parms);
   }

   public Template createTemplate(String source, String... parms) {
      return this.createTemplate((JexlInfo)null, (String)source, parms);
   }

   public Template createTemplate(String source) {
      return this.createTemplate((JexlInfo)null, (String)source);
   }

   public abstract JexlEngine getEngine();

   public abstract void clearCache();

   public static class Exception extends JexlException {
      private static final long serialVersionUID = 201112030113L;

      public Exception(JexlInfo info, String msg, Throwable cause) {
         super(info, msg, cause);
      }
   }

   public interface Expression {
      String asString();

      StringBuilder asString(StringBuilder var1);

      Object evaluate(JexlContext var1);

      Expression getSource();

      Set<List<String>> getVariables();

      boolean isDeferred();

      boolean isImmediate();

      Expression prepare(JexlContext var1);

      String toString();
   }

   public interface Template {
      String asString();

      void evaluate(JexlContext var1, Writer var2);

      void evaluate(JexlContext var1, Writer var2, Object... var3);

      Template prepare(JexlContext var1);

      Set<List<String>> getVariables();

      String[] getParameters();

      Map<String, Object> getPragmas();
   }
}
