package org.apache.commons.jexl3;

import java.util.HashMap;
import java.util.Map;

public class MapContext implements JexlContext {
   private final Map<String, Object> map;

   public MapContext() {
      this((Map)null);
   }

   public MapContext(Map<String, Object> vars) {
      this.map = (Map<String, Object>)(vars == null ? new HashMap() : vars);
   }

   public boolean has(String name) {
      return this.map.containsKey(name);
   }

   public Object get(String name) {
      return this.map.get(name);
   }

   public void set(String name, Object value) {
      this.map.put(name, value);
   }

   public void clear() {
      this.map.clear();
   }
}
