package org.apache.commons.jexl3;

public class ObjectContext<T> implements JexlContext, JexlContext.NamespaceResolver {
   private final JexlEngine jexl;
   private final T object;

   public ObjectContext(JexlEngine engine, T wrapped) {
      this.jexl = engine;
      this.object = wrapped;
   }

   public Object get(String name) {
      return this.jexl.getProperty(this.object, name);
   }

   public void set(String name, Object value) {
      this.jexl.setProperty(this.object, name, value);
   }

   public boolean has(String name) {
      return this.jexl.getUberspect().getPropertyGet(this.object, name) != null;
   }

   public Object resolveNamespace(String name) {
      return name != null && !name.isEmpty() ? null : this.object;
   }
}
