package org.apache.commons.jexl3.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;

class AscLongIterator implements Iterator<Long> {
   private final long min;
   private final long max;
   private long cursor;

   AscLongIterator(long l, long h) {
      this.min = l;
      this.max = h;
      this.cursor = this.min;
   }

   public boolean hasNext() {
      return this.cursor <= this.max;
   }

   public Long next() {
      if (this.cursor <= this.max) {
         return Long.valueOf((long)(this.cursor++));
      } else {
         throw new NoSuchElementException();
      }
   }

   public void remove() {
      throw new UnsupportedOperationException();
   }
}
