package org.apache.commons.jexl3.internal;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.parser.ASTJexlLambda;
import org.apache.commons.jexl3.parser.JexlNode;

public class Closure extends Script {
   protected final Scope.Frame frame;

   protected Closure(Interpreter theCaller, ASTJexlLambda lambda) {
      super(theCaller.jexl, null, lambda);
      this.frame = lambda.createFrame(theCaller.frame);
   }

   public String toString() {
      return this.getParsedText();
   }

   public String getParsedText() {
      Debugger debug = new Debugger();
      debug.debug(this.script, false);
      return debug.toString();
   }

   public int hashCode() {
      int hash = 17;
      hash = 31 * hash + (this.jexl != null ? this.jexl.hashCode() : 0);
      hash = 31 * hash + (this.source != null ? this.source.hashCode() : 0);
      hash = 31 * hash + (this.frame != null ? this.frame.hashCode() : 0);
      return hash;
   }

   public boolean equals(Object obj) {
      if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         Closure other = (Closure)obj;
         if (this.jexl != other.jexl) {
            return false;
         } else {
            if (this.source == null) {
               if (other.source != null) {
                  return false;
               }
            } else if (!this.source.equals(other.source)) {
               return false;
            }

            if (this.frame == other.frame || this.frame != null && this.frame.equals(other.frame)) {
               return true;
            } else {
               return false;
            }
         }
      }
   }

   public void setHoisted(int symbol, Object value) {
      if (this.script instanceof ASTJexlLambda) {
         ASTJexlLambda lambda = (ASTJexlLambda)this.script;
         Scope scope = lambda.getScope();
         if (scope != null) {
            Integer reg = scope.getHoisted(symbol);
            if (reg != null) {
               this.frame.set(reg, value);
            }
         }
      }

   }

   public Object evaluate(JexlContext context) {
      return this.execute(context, (Object[])null);
   }

   public Object execute(JexlContext context) {
      return this.execute(context, (Object[])null);
   }

   public Object execute(JexlContext context, Object... args) {
      Scope.Frame callFrame = null;
      if (this.frame != null) {
         callFrame = this.frame.assign(args);
      }

      Interpreter interpreter = this.jexl.createInterpreter(context, callFrame);
      JexlNode block = this.script.jjtGetChild(this.script.jjtGetNumChildren() - 1);
      return interpreter.interpret(block);
   }

   public Callable callable(JexlContext context, Object... args) {
      Scope.Frame local = null;
      if (this.frame != null) {
         local = this.frame.assign(args);
      }

      return new Callable(this.jexl.createInterpreter(context, local)) {
         public Object interpret() {
            JexlNode block = Closure.this.script.jjtGetChild(Closure.this.script.jjtGetNumChildren() - 1);
            return this.interpreter.interpret(block);
         }
      };
   }
}
