package org.apache.commons.jexl3.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;

class DescIntegerIterator implements Iterator<Integer> {
   private final int min;
   private final int max;
   private int cursor;

   public DescIntegerIterator(int l, int h) {
      this.min = l;
      this.max = h;
      this.cursor = this.max;
   }

   public boolean hasNext() {
      return this.cursor >= this.min;
   }

   public Integer next() {
      if (this.cursor >= this.min) {
         return this.cursor--;
      } else {
         throw new NoSuchElementException();
      }
   }

   public void remove() {
      throw new UnsupportedOperationException("Not supported.");
   }
}
