package org.apache.commons.jexl3.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;

class DescLongIterator implements Iterator<Long> {
   private final long min;
   private final long max;
   private long cursor;

   DescLongIterator(long l, long h) {
      this.min = l;
      this.max = h;
      this.cursor = this.max;
   }

   public boolean hasNext() {
      return this.cursor >= this.min;
   }

   public Long next() {
      if (this.cursor >= this.min) {
         return Long.valueOf((long)(this.cursor--));
      } else {
         throw new NoSuchElementException();
      }
   }

   public void remove() {
      throw new UnsupportedOperationException();
   }
}
