package org.apache.commons.jexl3.internal;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SoftCache<K, V> {
   private static final float LOAD_FACTOR = 0.75F;
   private final int size;
   private SoftReference<Map<K, V>> ref = null;
   private final ReadWriteLock lock;

   SoftCache(int theSize) {
      this.size = theSize;
      this.lock = new ReentrantReadWriteLock();
   }

   public int size() {
      return this.size;
   }

   public void clear() {
      this.lock.writeLock().lock();

      try {
         this.ref = null;
      } finally {
         this.lock.writeLock().unlock();
      }

   }

   public V get(K key) {
      this.lock.readLock().lock();

      Object var3;
      try {
         Map<K, V> map = this.ref != null ? (Map)this.ref.get() : null;
         var3 = map != null ? map.get(key) : null;
      } finally {
         this.lock.readLock().unlock();
      }

      return (V)var3;
   }

   public void put(K key, V script) {
      this.lock.writeLock().lock();

      try {
         Map<K, V> map = this.ref != null ? (Map)this.ref.get() : null;
         if (map == null) {
            map = this.<K, V>createCache(this.size);
            this.ref = new SoftReference(map);
         }

         map.put(key, script);
      } finally {
         this.lock.writeLock().unlock();
      }

   }

   public List<Map.Entry<K, V>> entries() {
      this.lock.readLock().lock();

      List var2;
      try {
         Map<K, V> map = this.ref != null ? (Map)this.ref.get() : null;
         if (map != null) {
            Set<Map.Entry<K, V>> set = map.entrySet();
            List<Map.Entry<K, V>> entries = new ArrayList(set.size());

            for(Map.Entry<K, V> e : set) {
               entries.add(new SoftCacheEntry(e));
            }

            Object var10 = entries;
            return (List<Map.Entry<K, V>>)var10;
         }

         var2 = Collections.emptyList();
      } finally {
         this.lock.readLock().unlock();
      }

      return var2;
   }
   //需要验证方法可行性
   public <K, V> Map<K, V> createCache(int cacheSize) {
      return new LinkedHashMap<K, V>(cacheSize, LOAD_FACTOR, true) {
         protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return size() > cacheSize;
         }
      };
   }
}
