package org.apache.commons.jexl3.internal;

import java.util.Map;

class SoftCacheEntry<K, V> implements Map.Entry<K, V> {
   private final K key;
   private final V value;

   SoftCacheEntry(Map.Entry<K, V> e) {
      this.key = (K)e.getKey();
      this.value = (V)e.getValue();
   }

   public K getKey() {
      return this.key;
   }

   public V getValue() {
      return this.value;
   }

   public V setValue(V v) {
      throw new UnsupportedOperationException("Not supported.");
   }
}
