package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.InvocationTargetException;

public final class BooleanGetExecutor extends AbstractExecutor.Get {
   private final String property;

   public static BooleanGetExecutor discover(Introspector is, Class<?> clazz, String property) {
      if (property != null && !property.isEmpty()) {
         java.lang.reflect.Method m = PropertyGetExecutor.discoverGet(is, "is", clazz, property);
         if (m != null && (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class)) {
            return new BooleanGetExecutor(clazz, m, property);
         }
      }

      return null;
   }

   private BooleanGetExecutor(Class<?> clazz, java.lang.reflect.Method method, String key) {
      super(clazz, method);
      this.property = key;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object obj) throws IllegalAccessException, InvocationTargetException {
      return this.method == null ? null : this.method.invoke(obj, (Object[])null);
   }

   public Object tryInvoke(Object obj, Object key) {
      if (obj != null && this.method != null && this.property.equals(key) && this.objectClass.equals(obj.getClass())) {
         try {
            return this.method.invoke(obj, (Object[])null);
         } catch (InvocationTargetException var4) {
            return TRY_FAILED;
         } catch (IllegalAccessException var5) {
            return TRY_FAILED;
         }
      } else {
         return TRY_FAILED;
      }
   }
}
