package org.apache.commons.jexl3.internal.introspection;

import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.jexl3.introspection.JexlMethod;

public final class ConstructorMethod implements JexlMethod {
   private final Constructor<?> ctor;

   public static ConstructorMethod discover(Introspector is, Object ctorHandle, Object... args) {
      Class<?> clazz = null;
      String className;
      if (ctorHandle instanceof Class) {
         clazz = (Class)ctorHandle;
         className = clazz.getName();
      } else {
         if (ctorHandle == null) {
            return null;
         }

         className = ctorHandle.toString();
      }

      Constructor<?> ctor = is.getConstructor(clazz, new MethodKey(className, args));
      return ctor != null ? new ConstructorMethod(ctor) : null;
   }

   ConstructorMethod(Constructor<?> theCtor) {
      this.ctor = theCtor;
   }

   public Object invoke(Object obj, Object... params) throws Exception {
      Class<?> ctorClass = this.ctor.getDeclaringClass();
      boolean invoke = true;
      if (obj != null) {
         if (obj instanceof Class) {
            invoke = ctorClass.equals((Class)obj);
         } else {
            invoke = ctorClass.getName().equals(obj.toString());
         }
      }

      if (invoke) {
         return this.ctor.newInstance(params);
      } else {
         throw new IntrospectionException("constructor resolution error");
      }
   }

   public Object tryInvoke(String name, Object obj, Object... params) {
      try {
         Class<?> ctorClass = this.ctor.getDeclaringClass();
         boolean invoke = true;
         if (obj != null) {
            if (obj instanceof Class) {
               invoke = ctorClass.equals((Class)obj);
            } else {
               invoke = ctorClass.getName().equals(obj.toString());
            }
         }

         invoke &= name == null || ctorClass.getName().equals(name);
         if (invoke) {
            return this.ctor.newInstance(params);
         }
      } catch (InstantiationException var6) {
         return Uberspect.TRY_FAILED;
      } catch (IllegalAccessException var7) {
         return Uberspect.TRY_FAILED;
      } catch (IllegalArgumentException var8) {
         return Uberspect.TRY_FAILED;
      } catch (InvocationTargetException var9) {
         return Uberspect.TRY_FAILED;
      }

      return Uberspect.TRY_FAILED;
   }

   public boolean tryFailed(Object rval) {
      return rval == Uberspect.TRY_FAILED;
   }

   public boolean isCacheable() {
      return true;
   }

   public Class<?> getReturnType() {
      return this.ctor.getDeclaringClass();
   }
}
