package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.InvocationTargetException;

public final class DuckGetExecutor extends AbstractExecutor.Get {
   private final Object property;

   public static DuckGetExecutor discover(Introspector is, Class<?> clazz, Object identifier) {
      java.lang.reflect.Method method = is.getMethod(clazz, "get", makeArgs(new Object[]{identifier}));
      return method == null ? null : new DuckGetExecutor(clazz, method, identifier);
   }

   private DuckGetExecutor(Class<?> clazz, java.lang.reflect.Method method, Object identifier) {
      super(clazz, method);
      this.property = identifier;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object obj) throws IllegalAccessException, InvocationTargetException {
      Object[] args = new Object[]{this.property};
      return this.method == null ? null : this.method.invoke(obj, args);
   }

   public Object tryInvoke(Object obj, Object key) {
      if (obj != null && this.objectClass.equals(obj.getClass()) && this.method != null && (this.property == null && key == null || this.property != null && this.property.equals(key))) {
         try {
            Object[] args = new Object[]{this.property};
            return this.method.invoke(obj, args);
         } catch (InvocationTargetException var4) {
            return TRY_FAILED;
         } catch (IllegalAccessException var5) {
            return TRY_FAILED;
         } catch (IllegalArgumentException var6) {
            return TRY_FAILED;
         }
      } else {
         return TRY_FAILED;
      }
   }
}
