package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.InvocationTargetException;

public final class DuckSetExecutor extends AbstractExecutor.Set {
   private final Object property;

   public static DuckSetExecutor discover(Introspector is, Class<?> clazz, Object key, Object value) {
      java.lang.reflect.Method method = is.getMethod(clazz, "set", makeArgs(new Object[]{key, value}));
      if (method == null) {
         method = is.getMethod(clazz, "put", makeArgs(new Object[]{key, value}));
      }

      return method == null ? null : new DuckSetExecutor(clazz, method, key);
   }

   private DuckSetExecutor(Class<?> clazz, java.lang.reflect.Method method, Object key) {
      super(clazz, method);
      this.property = key;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object obj, Object value) throws IllegalAccessException, InvocationTargetException {
      Object[] pargs = new Object[]{this.property, value};
      if (this.method != null) {
         this.method.invoke(obj, pargs);
      }

      return value;
   }

   public Object tryInvoke(Object obj, Object key, Object value) {
      if (obj != null && this.objectClass.equals(obj.getClass()) && this.method != null && (this.property != null && this.property.equals(key) || this.property == null && key == null)) {
         try {
            Object[] args = new Object[]{this.property, value};
            this.method.invoke(obj, args);
            return value;
         } catch (InvocationTargetException var5) {
            return TRY_FAILED;
         } catch (IllegalAccessException var6) {
            return TRY_FAILED;
         } catch (IllegalArgumentException var7) {
            return TRY_FAILED;
         }
      } else {
         return TRY_FAILED;
      }
   }
}
