package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Field;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;

public final class FieldGetExecutor implements JexlPropertyGet {
   private final Field field;

   public static JexlPropertyGet discover(Introspector is, Class<?> clazz, String identifier) {
      if (identifier != null) {
         Field field = is.getField(clazz, identifier);
         if (field != null) {
            return new FieldGetExecutor(field);
         }
      }

      return null;
   }

   private FieldGetExecutor(Field theField) {
      this.field = theField;
   }

   public Object invoke(Object obj) throws Exception {
      return this.field.get(obj);
   }

   public Object tryInvoke(Object obj, Object key) {
      if (obj.getClass().equals(this.field.getDeclaringClass()) && key.equals(this.field.getName())) {
         try {
            return this.field.get(obj);
         } catch (IllegalAccessException var4) {
            return Uberspect.TRY_FAILED;
         }
      } else {
         return Uberspect.TRY_FAILED;
      }
   }

   public boolean tryFailed(Object rval) {
      return rval == Uberspect.TRY_FAILED;
   }

   public boolean isCacheable() {
      return true;
   }
}
