package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Array;
import java.util.List;

public final class ListGetExecutor extends AbstractExecutor.Get {
   private static final java.lang.reflect.Method ARRAY_GET;
   private static final java.lang.reflect.Method LIST_GET;
   private final Integer property;

   public static ListGetExecutor discover(Introspector is, Class<?> clazz, Integer index) {
      if (index != null) {
         if (clazz.isArray()) {
            return new ListGetExecutor(clazz, ARRAY_GET, index);
         }

         if (List.class.isAssignableFrom(clazz)) {
            return new ListGetExecutor(clazz, LIST_GET, index);
         }
      }

      return null;
   }

   private ListGetExecutor(Class<?> clazz, java.lang.reflect.Method method, Integer index) {
      super(clazz, method);
      this.property = index;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object obj) {
      return this.method == ARRAY_GET ? Array.get(obj, this.property) : ((List)obj).get(this.property);
   }

   public Object tryInvoke(Object obj, Object identifier) {
      Integer index = castInteger(identifier);
      if (obj != null && this.method != null && this.objectClass.equals(obj.getClass()) && index != null) {
         return this.method == ARRAY_GET ? Array.get(obj, index) : ((List)obj).get(index);
      } else {
         return TRY_FAILED;
      }
   }

   static {
      ARRAY_GET = initMarker(Array.class, "get", new Class[]{Object.class, Integer.TYPE});
      LIST_GET = initMarker(List.class, "get", new Class[]{Integer.TYPE});
   }
}
