package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Array;
import java.util.List;

public final class ListSetExecutor extends AbstractExecutor.Set {
   private static final java.lang.reflect.Method ARRAY_SET;
   private static final java.lang.reflect.Method LIST_SET;
   private final Integer property;

   public static ListSetExecutor discover(Introspector is, Class<?> clazz, Object identifier, Object value) {
      Integer index = castInteger(identifier);
      if (index != null) {
         if (clazz.isArray()) {
            return new ListSetExecutor(clazz, ARRAY_SET, index);
         }

         if (List.class.isAssignableFrom(clazz)) {
            return new ListSetExecutor(clazz, LIST_SET, index);
         }
      }

      return null;
   }

   private ListSetExecutor(Class<?> clazz, java.lang.reflect.Method method, Integer key) {
      super(clazz, method);
      this.property = key;
   }

   public Object getTargetProperty() {
      return this.property;
   }

   public Object invoke(Object obj, Object value) {
      if (this.method == ARRAY_SET) {
         Array.set(obj, this.property, value);
      } else {
         List<Object> list = (List)obj;
         list.set(this.property, value);
      }

      return value;
   }

   public Object tryInvoke(Object obj, Object key, Object value) {
      Integer index = castInteger(key);
      if (obj != null && this.method != null && this.objectClass.equals(obj.getClass()) && index != null) {
         if (this.method == ARRAY_SET) {
            Array.set(obj, index, value);
         } else {
            List<Object> list = (List)obj;
            list.set(index, value);
         }

         return value;
      } else {
         return TRY_FAILED;
      }
   }

   static {
      ARRAY_SET = initMarker(Array.class, "set", new Class[]{Object.class, Integer.TYPE, Object.class});
      LIST_SET = initMarker(List.class, "set", new Class[]{Integer.TYPE, Object.class});
   }
}
